package org.openqa.selenium.devtools.v107.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum ClientHintIssueReason {

    METATAGALLOWLISTINVALIDORIGIN("MetaTagAllowListInvalidOrigin"), METATAGMODIFIEDHTML("MetaTagModifiedHTML");

    private String value;

    ClientHintIssueReason(String value) {
        this.value = value;
    }

    public static ClientHintIssueReason fromString(String s) {
        return java.util.Arrays.stream(ClientHintIssueReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ClientHintIssueReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ClientHintIssueReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
