/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.sonar.runner.api.EmbeddedRunner;
import org.sonar.runner.api.LogOutput;

public class SonarQubeTask
extends DefaultTask {
    private static final Logger LOGGER = Logging.getLogger(SonarQubeTask.class);
    public static final LogOutput LOG_OUTPUT = new LogOutput(){

        public void log(String formattedMessage, LogOutput.Level level) {
            switch (level) {
                case TRACE: {
                    LOGGER.trace(formattedMessage);
                    return;
                }
                case DEBUG: {
                    LOGGER.debug(formattedMessage);
                    return;
                }
                case INFO: {
                    LOGGER.info(formattedMessage);
                    return;
                }
                case WARN: {
                    LOGGER.warn(formattedMessage);
                    return;
                }
                case ERROR: {
                    LOGGER.error(formattedMessage);
                    return;
                }
            }
            throw new IllegalArgumentException(level.name());
        }
    };
    private Map<String, Object> sonarProperties;

    @TaskAction
    public void run() {
        Map<String, Object> properties = this.getProperties();
        Properties propertiesObject = new Properties();
        propertiesObject.putAll(properties);
        EmbeddedRunner runner = EmbeddedRunner.create((LogOutput)LOG_OUTPUT).setApp("Gradle", this.getProject().getGradle().getGradleVersion()).addGlobalProperties(propertiesObject);
        runner.start();
        runner.runAnalysis(propertiesObject);
        runner.stop();
    }

    @Input
    public Map<String, Object> getProperties() {
        if (this.sonarProperties == null) {
            this.sonarProperties = Maps.newLinkedHashMap();
        }
        return this.sonarProperties;
    }
}

