/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.tasks.bundling.BootArchive;
import org.springframework.boot.gradle.tasks.bundling.BootArchiveSupport;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.LayerResolver;
import org.springframework.boot.gradle.tasks.bundling.LayeredSpec;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;

public class BootJar
extends Jar
implements BootArchive {
    private static final String LAUNCHER = "org.springframework.boot.loader.JarLauncher";
    private static final String CLASSES_DIRECTORY = "BOOT-INF/classes/";
    private static final String LIB_DIRECTORY = "BOOT-INF/lib/";
    private static final String LAYERS_INDEX = "BOOT-INF/layers.idx";
    private static final String CLASSPATH_INDEX = "BOOT-INF/classpath.idx";
    private final BootArchiveSupport support = new BootArchiveSupport("org.springframework.boot.loader.JarLauncher", (Spec<FileCopyDetails>)((Spec)this::isLibrary), this::resolveZipCompression);
    private final CopySpec bootInfSpec = this.getProject().copySpec().into((Object)"BOOT-INF");
    private String mainClassName;
    private FileCollection classpath;
    private LayeredSpec layered;

    public BootJar() {
        this.configureBootInfSpec(this.bootInfSpec);
        this.getMainSpec().with(new CopySpec[]{this.bootInfSpec});
    }

    private void configureBootInfSpec(CopySpec bootInfSpec) {
        bootInfSpec.into((Object)"classes", BootJar.fromCallTo(this::classpathDirectories));
        bootInfSpec.into((Object)"lib", BootJar.fromCallTo(this::classpathFiles)).eachFile(this.support::excludeNonZipFiles);
        bootInfSpec.filesMatching("module-info.class", details -> details.setRelativePath(details.getRelativeSourcePath()));
    }

    private Iterable<File> classpathDirectories() {
        return this.classpathEntries((Spec<File>)((Spec)File::isDirectory));
    }

    private Iterable<File> classpathFiles() {
        return this.classpathEntries((Spec<File>)((Spec)File::isFile));
    }

    private Iterable<File> classpathEntries(Spec<File> filter) {
        return this.classpath != null ? this.classpath.filter(filter) : Collections.emptyList();
    }

    public void copy() {
        this.support.configureManifest(this.getManifest(), this.getMainClassName(), CLASSES_DIRECTORY, LIB_DIRECTORY, CLASSPATH_INDEX, this.layered != null ? LAYERS_INDEX : null);
        super.copy();
    }

    protected CopyAction createCopyAction() {
        if (this.layered != null) {
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
            SourceSetContainer sourceSets = javaPluginConvention != null ? javaPluginConvention.getSourceSets() : Collections.emptySet();
            LayerResolver layerResolver = new LayerResolver((Iterable<SourceSet>)sourceSets, this.getConfigurations(), this.layered, (Spec<FileCopyDetails>)((Spec)this::isLibrary));
            String layerToolsLocation = this.layered.isIncludeLayerTools() ? LIB_DIRECTORY : null;
            return this.support.createCopyAction(this, layerResolver, layerToolsLocation);
        }
        return this.support.createCopyAction(this);
    }

    @Internal
    protected Iterable<Configuration> getConfigurations() {
        return this.getProject().getConfigurations();
    }

    @Override
    public String getMainClassName() {
        String manifestStartClass;
        if (this.mainClassName == null && (manifestStartClass = (String)this.getManifest().getAttributes().get((Object)"Start-Class")) != null) {
            this.setMainClassName(manifestStartClass);
        }
        return this.mainClassName;
    }

    @Override
    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    @Override
    public void requiresUnpack(String ... patterns) {
        this.support.requiresUnpack(patterns);
    }

    @Override
    public void requiresUnpack(Spec<FileTreeElement> spec) {
        this.support.requiresUnpack(spec);
    }

    @Override
    public LaunchScriptConfiguration getLaunchScript() {
        return this.support.getLaunchScript();
    }

    @Override
    public void launchScript() {
        this.enableLaunchScriptIfNecessary();
    }

    @Override
    public void launchScript(Action<LaunchScriptConfiguration> action) {
        action.execute((Object)this.enableLaunchScriptIfNecessary());
    }

    @Nested
    @Optional
    public LayeredSpec getLayered() {
        return this.layered;
    }

    public void layered() {
        this.enableLayeringIfNecessary();
    }

    public void layered(Action<LayeredSpec> action) {
        action.execute((Object)this.enableLayeringIfNecessary());
    }

    @Override
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public void classpath(Object ... classpath) {
        FileCollection existingClasspath = this.classpath;
        this.classpath = this.getProject().files(new Object[]{existingClasspath != null ? existingClasspath : Collections.emptyList(), classpath});
    }

    @Override
    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @Override
    public void setClasspath(FileCollection classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @Override
    public boolean isExcludeDevtools() {
        return this.support.isExcludeDevtools();
    }

    @Override
    public void setExcludeDevtools(boolean excludeDevtools) {
        this.support.setExcludeDevtools(excludeDevtools);
    }

    @Internal
    public CopySpec getBootInf() {
        CopySpec child = this.getProject().copySpec();
        this.bootInfSpec.with(new CopySpec[]{child});
        return child;
    }

    public CopySpec bootInf(Action<CopySpec> action) {
        CopySpec bootInf = this.getBootInf();
        action.execute((Object)bootInf);
        return bootInf;
    }

    protected ZipCompression resolveZipCompression(FileCopyDetails details) {
        return this.isLibrary(details) ? ZipCompression.STORED : ZipCompression.DEFLATED;
    }

    protected boolean isLibrary(FileCopyDetails details) {
        String path = details.getRelativePath().getPathString();
        return path.startsWith(LIB_DIRECTORY);
    }

    private LaunchScriptConfiguration enableLaunchScriptIfNecessary() {
        LaunchScriptConfiguration launchScript = this.support.getLaunchScript();
        if (launchScript == null) {
            launchScript = new LaunchScriptConfiguration((AbstractArchiveTask)this);
            this.support.setLaunchScript(launchScript);
        }
        return launchScript;
    }

    private LayeredSpec enableLayeringIfNecessary() {
        if (this.layered == null) {
            this.layered = new LayeredSpec();
        }
        return this.layered;
    }

    private static <T> Action<CopySpec> fromCallTo(Callable<T> callable) {
        return spec -> spec.from(new Object[]{BootJar.callTo(callable)});
    }

    private static <T> Callable<T> callTo(Callable<T> callable) {
        return callable;
    }
}

