/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.http.HttpClientResponse;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpClientRequest;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpClientResponse;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpan;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;

public class BraveHttpClientHandler
implements HttpClientHandler {
    final brave.http.HttpClientHandler<brave.http.HttpClientRequest, HttpClientResponse> delegate;

    public BraveHttpClientHandler(brave.http.HttpClientHandler<brave.http.HttpClientRequest, HttpClientResponse> delegate) {
        this.delegate = delegate;
    }

    public Span handleSend(HttpClientRequest request) {
        return BraveSpan.fromBrave(this.delegate.handleSend(BraveHttpClientRequest.toBrave(request)));
    }

    public Span handleSend(HttpClientRequest request, TraceContext parent) {
        brave.Span span = this.delegate.handleSendWithParent(BraveHttpClientRequest.toBrave(request), BraveTraceContext.toBrave(parent));
        if (!span.isNoop()) {
            span.remoteIpAndPort(request.remoteIp(), request.remotePort());
        }
        return BraveSpan.fromBrave(span);
    }

    public void handleReceive(org.springframework.cloud.sleuth.http.HttpClientResponse response, Span span) {
        this.delegate.handleReceive(BraveHttpClientResponse.toBrave(response), BraveSpan.toBrave(span));
    }
}

