/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import java.util.Objects;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;

class BraveSpan
implements Span {
    final brave.Span delegate;

    BraveSpan(brave.Span delegate) {
        this.delegate = delegate;
    }

    public boolean isNoop() {
        return this.delegate.isNoop();
    }

    public TraceContext context() {
        if (this.delegate == null) {
            return null;
        }
        return new BraveTraceContext(this.delegate.context());
    }

    public Span start() {
        return new BraveSpan(this.delegate.start());
    }

    public Span name(String name) {
        return new BraveSpan(this.delegate.name(name));
    }

    public Span event(String value) {
        return new BraveSpan(this.delegate.annotate(value));
    }

    public Span tag(String key, String value) {
        return new BraveSpan(this.delegate.tag(key, value));
    }

    public Span error(Throwable throwable) {
        String message = throwable.getMessage() == null ? throwable.getClass().getSimpleName() : throwable.getMessage();
        this.delegate.tag("error", message);
        this.delegate.error(throwable);
        return new BraveSpan(this.delegate);
    }

    public void end() {
        this.delegate.finish();
    }

    public void abandon() {
        this.delegate.abandon();
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    static brave.Span toBrave(Span span) {
        return ((BraveSpan)span).delegate;
    }

    static Span fromBrave(brave.Span span) {
        return new BraveSpan(span);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BraveSpan braveSpan = (BraveSpan)o;
        return Objects.equals(this.delegate, braveSpan.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

