/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.MongoCredential;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MongoCredentialPropertyEditor
extends PropertyEditorSupport {
    private static final Pattern GROUP_PATTERN = Pattern.compile("(\\\\?')(.*?)\\1");
    private static final String AUTH_MECHANISM_KEY = "uri.authMechanism";
    private static final String USERNAME_PASSWORD_DELIMINATOR = ":";
    private static final String DATABASE_DELIMINATOR = "@";
    private static final String OPTIONS_DELIMINATOR = "?";
    private static final String OPTION_VALUE_DELIMINATOR = "&";

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.hasText((String)text)) {
            return;
        }
        ArrayList<Object> credentials = new ArrayList<Object>();
        for (String credentialString : this.extractCredentialsString(text)) {
            String[] userNameAndPassword = MongoCredentialPropertyEditor.extractUserNameAndPassword(credentialString);
            String database = MongoCredentialPropertyEditor.extractDB(credentialString);
            Properties options = MongoCredentialPropertyEditor.extractOptions(credentialString);
            if (!options.isEmpty()) {
                if (!options.containsKey(AUTH_MECHANISM_KEY)) continue;
                String authMechanism = options.getProperty(AUTH_MECHANISM_KEY);
                if ("GSSAPI".equals(authMechanism)) {
                    MongoCredentialPropertyEditor.verifyUserNamePresent(userNameAndPassword);
                    credentials.add(MongoCredential.createGSSAPICredential((String)userNameAndPassword[0]));
                    continue;
                }
                if ("MONGODB-CR".equals(authMechanism)) {
                    MongoCredentialPropertyEditor.verifyUsernameAndPasswordPresent(userNameAndPassword);
                    MongoCredentialPropertyEditor.verifyDatabasePresent(database);
                    credentials.add(MongoCredential.createMongoCRCredential((String)userNameAndPassword[0], (String)database, (char[])userNameAndPassword[1].toCharArray()));
                    continue;
                }
                if ("MONGODB-X509".equals(authMechanism)) {
                    MongoCredentialPropertyEditor.verifyUserNamePresent(userNameAndPassword);
                    credentials.add(MongoCredential.createMongoX509Credential((String)userNameAndPassword[0]));
                    continue;
                }
                if ("PLAIN".equals(authMechanism)) {
                    MongoCredentialPropertyEditor.verifyUsernameAndPasswordPresent(userNameAndPassword);
                    MongoCredentialPropertyEditor.verifyDatabasePresent(database);
                    credentials.add(MongoCredential.createPlainCredential((String)userNameAndPassword[0], (String)database, (char[])userNameAndPassword[1].toCharArray()));
                    continue;
                }
                if ("SCRAM-SHA-1".equals(authMechanism)) {
                    MongoCredentialPropertyEditor.verifyUsernameAndPasswordPresent(userNameAndPassword);
                    MongoCredentialPropertyEditor.verifyDatabasePresent(database);
                    credentials.add(MongoCredential.createScramSha1Credential((String)userNameAndPassword[0], (String)database, (char[])userNameAndPassword[1].toCharArray()));
                    continue;
                }
                if ("SCRAM-SHA-256".equals(authMechanism)) {
                    Method createScramSha256Credential = ReflectionUtils.findMethod(MongoCredential.class, (String)"createScramSha256Credential", (Class[])new Class[]{String.class, String.class, char[].class});
                    if (createScramSha256Credential == null) {
                        throw new IllegalArgumentException("SCRAM-SHA-256 auth mechanism is available as of MongoDB 4 and MongoDB Java Driver 3.8! Please make sure to use at least those versions.");
                    }
                    MongoCredentialPropertyEditor.verifyUsernameAndPasswordPresent(userNameAndPassword);
                    MongoCredentialPropertyEditor.verifyDatabasePresent(database);
                    credentials.add(MongoCredential.class.cast(ReflectionUtils.invokeMethod((Method)createScramSha256Credential, null, (Object[])new Object[]{userNameAndPassword[0], database, userNameAndPassword[1].toCharArray()})));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Cannot create MongoCredentials for unknown auth mechanism '%s'!", authMechanism));
            }
            MongoCredentialPropertyEditor.verifyUsernameAndPasswordPresent(userNameAndPassword);
            MongoCredentialPropertyEditor.verifyDatabasePresent(database);
            credentials.add(MongoCredential.createCredential((String)userNameAndPassword[0], (String)database, (char[])userNameAndPassword[1].toCharArray()));
        }
        this.setValue(credentials);
    }

    private List<String> extractCredentialsString(String source) {
        Matcher matcher = GROUP_PATTERN.matcher(source);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String value = StringUtils.trimLeadingCharacter((String)matcher.group(), (char)'\'');
            list.add(StringUtils.trimTrailingCharacter((String)value, (char)'\''));
        }
        if (!list.isEmpty()) {
            return list;
        }
        return Arrays.asList(source.split(","));
    }

    private static String[] extractUserNameAndPassword(String text) {
        int index = text.lastIndexOf(DATABASE_DELIMINATOR);
        index = index != -1 ? index : text.lastIndexOf(OPTIONS_DELIMINATOR);
        return index == -1 ? new String[]{} : text.substring(0, index).split(USERNAME_PASSWORD_DELIMINATOR);
    }

    private static String extractDB(String text) {
        int dbSeperationIndex = text.lastIndexOf(DATABASE_DELIMINATOR);
        if (dbSeperationIndex == -1) {
            return "";
        }
        String tmp = text.substring(dbSeperationIndex + 1);
        int optionsSeperationIndex = tmp.lastIndexOf(OPTIONS_DELIMINATOR);
        return optionsSeperationIndex > -1 ? tmp.substring(0, optionsSeperationIndex) : tmp;
    }

    private static Properties extractOptions(String text) {
        int optionsSeperationIndex = text.lastIndexOf(OPTIONS_DELIMINATOR);
        int dbSeperationIndex = text.lastIndexOf(DATABASE_DELIMINATOR);
        if (optionsSeperationIndex == -1 || dbSeperationIndex > optionsSeperationIndex) {
            return new Properties();
        }
        Properties properties = new Properties();
        for (String option : text.substring(optionsSeperationIndex + 1).split(OPTION_VALUE_DELIMINATOR)) {
            String[] optionArgs = option.split("=");
            if (optionArgs.length == 1) {
                throw new IllegalArgumentException(String.format("Query parameter '%s' has no value!", optionArgs[0]));
            }
            properties.put(optionArgs[0], optionArgs[1]);
        }
        return properties;
    }

    private static void verifyUsernameAndPasswordPresent(String[] source) {
        MongoCredentialPropertyEditor.verifyUserNamePresent(source);
        if (source.length != 2) {
            throw new IllegalArgumentException("Credentials need to specify username and password like in 'username:password@database'!");
        }
    }

    private static void verifyDatabasePresent(String source) {
        if (!StringUtils.hasText((String)source)) {
            throw new IllegalArgumentException("Credentials need to specify database like in 'username:password@database'!");
        }
    }

    private static void verifyUserNamePresent(String[] source) {
        if (source.length == 0 || !StringUtils.hasText((String)source[0])) {
            throw new IllegalArgumentException("Credentials need to specify username!");
        }
    }
}

