/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.IndexEnsuringQueryCreationListener;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class MongoRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private MongoOperations operations;
    private boolean createIndexesForQueryMethods = false;
    private boolean mappingContextConfigured = false;

    public MongoRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setMongoOperations(MongoOperations operations) {
        this.operations = operations;
    }

    public void setCreateIndexesForQueryMethods(boolean createIndexesForQueryMethods) {
        this.createIndexesForQueryMethods = createIndexesForQueryMethods;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        RepositoryFactorySupport factory = this.getFactoryInstance(this.operations);
        if (this.createIndexesForQueryMethods) {
            factory.addQueryCreationListener((QueryCreationListener)new IndexEnsuringQueryCreationListener(this.operations));
        }
        return factory;
    }

    protected RepositoryFactorySupport getFactoryInstance(MongoOperations operations) {
        return new MongoRepositoryFactory(operations);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.operations, (String)"MongoTemplate must not be null!");
        if (!this.mappingContextConfigured) {
            this.setMappingContext(this.operations.getConverter().getMappingContext());
        }
    }
}

