/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.solr.client.solrj.SolrQuery;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.solr.core.query.result.Cursor;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class DelegatingCursor<T>
implements Cursor<T> {
    private Cursor.State state;
    @Nullable
    private String cursorMark;
    private long position;
    private Iterator<T> delegate;
    private final SolrQuery referenceQuery;

    protected DelegatingCursor(SolrQuery query) {
        this(query, "*");
    }

    protected DelegatingCursor(SolrQuery query, String initalCursorMark) {
        this.referenceQuery = query;
        this.cursorMark = StringUtils.hasText((String)initalCursorMark) ? initalCursorMark : "*";
        this.state = Cursor.State.REDAY;
        this.delegate = Collections.emptyList().iterator();
    }

    @Override
    public boolean hasNext() {
        this.validateState();
        if (!this.delegate.hasNext() && !this.isFinished()) {
            this.load(this.getCursorMark());
        }
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        this.validateState();
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available for cursor " + this.getCursorMark() + ".");
        }
        T next = this.moveNext(this.delegate);
        ++this.position;
        return next;
    }

    protected T moveNext(Iterator<T> source) {
        return source.next();
    }

    private void load(@Nullable String cursorMark) {
        SolrQuery query = this.referenceQuery.getCopy();
        query.set("cursorMark", new String[]{cursorMark});
        PartialResult<T> result = this.doLoad(query);
        this.process(result);
    }

    protected abstract PartialResult<T> doLoad(SolrQuery var1);

    private void process(@Nullable PartialResult<T> result) {
        if (result == null) {
            this.delegate = Collections.emptyList().iterator();
            this.state = Cursor.State.FINISHED;
            return;
        }
        if (this.getCursorMark().equals(result.getNextCursorMark())) {
            this.state = Cursor.State.FINISHED;
        }
        this.cursorMark = result.getNextCursorMark();
        if (!CollectionUtils.isEmpty(result.getItems())) {
            this.delegate = result.iterator();
        } else {
            Collections.emptyList().iterator();
        }
    }

    @Override
    public DelegatingCursor<T> open() {
        if (!this.isReady()) {
            throw new InvalidDataAccessApiUsageException("Cursor already " + (Object)((Object)this.state) + ". Cannot (re)open it.");
        }
        this.state = Cursor.State.OPEN;
        this.doOpen(this.getCursorMark());
        return this;
    }

    protected void doOpen(@Nullable String cursorMark) {
        this.load(cursorMark);
    }

    @Override
    public void close() throws IOException {
        try {
            this.doClose();
        }
        finally {
            this.state = Cursor.State.CLOSED;
        }
    }

    protected void doClose() {
        this.delegate = Collections.emptyList().iterator();
        this.referenceQuery.clear();
        this.position = -1L;
        this.cursorMark = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removing elements from cursor is not supported");
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Nullable
    public String getCursorMark() {
        return this.cursorMark;
    }

    public boolean isReady() {
        return Cursor.State.REDAY.equals((Object)this.state);
    }

    @Override
    public boolean isOpen() {
        return Cursor.State.OPEN.equals((Object)this.state);
    }

    public boolean isFinished() {
        return Cursor.State.FINISHED.equals((Object)this.state);
    }

    @Override
    public boolean isClosed() {
        return Cursor.State.CLOSED.equals((Object)this.state);
    }

    private void validateState() {
        if (this.isReady() || this.isClosed()) {
            throw new InvalidDataAccessApiUsageException("Cannot access closed cursor. Did you forget to call open()?");
        }
    }

    public static class PartialResult<T>
    implements Iterable<T> {
        private String nextCursorMark;
        private Collection<T> items;

        public PartialResult(String nextCursorMark, @Nullable Collection<T> items) {
            this.nextCursorMark = nextCursorMark;
            this.items = items != null ? new ArrayList<T>(items) : Collections.emptyList();
        }

        public String getNextCursorMark() {
            return this.nextCursorMark;
        }

        public Collection<T> getItems() {
            return this.items;
        }

        @Override
        public Iterator<T> iterator() {
            return this.items.iterator();
        }
    }
}

