/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.net.URI;
import java.util.function.Supplier;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private int maxFramePayloadLength = 65536;

    public void setMaxFramePayloadLength(Integer maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public int getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpResponse response = exchange.getResponse();
        HttpServerResponse reactorResponse = (HttpServerResponse)((AbstractServerHttpResponse)response).getNativeResponse();
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        NettyDataBufferFactory bufferFactory = (NettyDataBufferFactory)response.bufferFactory();
        return reactorResponse.sendWebsocket(subProtocol, this.maxFramePayloadLength, (in, out) -> {
            ReactorNettyWebSocketSession session = new ReactorNettyWebSocketSession((WebsocketInbound)in, (WebsocketOutbound)out, handshakeInfo, bufferFactory, this.maxFramePayloadLength);
            URI uri = exchange.getRequest().getURI();
            return handler.handle(session).checkpoint(uri + " [ReactorNettyRequestUpgradeStrategy]");
        });
    }
}

