/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.ContentVersionStrategy;
import org.springframework.web.reactive.resource.FixedVersionStrategy;
import org.springframework.web.reactive.resource.HttpResource;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.reactive.resource.VersionStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class VersionResourceResolver
extends AbstractResourceResolver {
    private final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, VersionStrategy> versionStrategyMap = new LinkedHashMap<String, VersionStrategy>();

    public void setStrategyMap(Map<String, VersionStrategy> map) {
        this.versionStrategyMap.clear();
        this.versionStrategyMap.putAll(map);
    }

    public Map<String, VersionStrategy> getStrategyMap() {
        return this.versionStrategyMap;
    }

    public VersionResourceResolver addContentVersionStrategy(String ... pathPatterns) {
        this.addVersionStrategy(new ContentVersionStrategy(), pathPatterns);
        return this;
    }

    public VersionResourceResolver addFixedVersionStrategy(String version, String ... pathPatterns) {
        List<String> patternsList = Arrays.asList(pathPatterns);
        ArrayList<Object> prefixedPatterns = new ArrayList<Object>(pathPatterns.length);
        String versionPrefix = "/" + version;
        for (String pattern : patternsList) {
            prefixedPatterns.add(pattern);
            if (pattern.startsWith(versionPrefix) || patternsList.contains(versionPrefix + pattern)) continue;
            prefixedPatterns.add(versionPrefix + pattern);
        }
        return this.addVersionStrategy(new FixedVersionStrategy(version), StringUtils.toStringArray(prefixedPatterns));
    }

    public VersionResourceResolver addVersionStrategy(VersionStrategy strategy, String ... pathPatterns) {
        for (String pattern : pathPatterns) {
            this.getStrategyMap().put(pattern, strategy);
        }
        return this;
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(@Nullable ServerWebExchange exchange2, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveResource(exchange2, requestPath, locations).switchIfEmpty(Mono.defer(() -> this.resolveVersionedResource(exchange2, requestPath, locations, chain)));
    }

    private Mono<Resource> resolveVersionedResource(@Nullable ServerWebExchange exchange2, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        VersionStrategy versionStrategy = this.getStrategyForPath(requestPath);
        if (versionStrategy == null) {
            return Mono.empty();
        }
        String candidate = versionStrategy.extractVersion(requestPath);
        if (!StringUtils.hasLength((String)candidate)) {
            return Mono.empty();
        }
        String simplePath = versionStrategy.removeVersion(requestPath, candidate);
        return chain.resolveResource(exchange2, simplePath, locations).filterWhen(resource -> versionStrategy.getResourceVersion((Resource)resource).map(actual -> {
            if (candidate.equals(actual)) {
                return true;
            }
            if (this.logger.isTraceEnabled()) {
                String logPrefix = exchange2 != null ? exchange2.getLogPrefix() : "";
                this.logger.trace((Object)(logPrefix + "Found resource for \"" + requestPath + "\", but version [" + candidate + "] does not match"));
            }
            return false;
        })).map(resource -> new FileNameVersionedResource((Resource)resource, candidate));
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourceUrlPath, locations).flatMap(baseUrl -> {
            if (StringUtils.hasText((String)baseUrl)) {
                VersionStrategy strategy = this.getStrategyForPath(resourceUrlPath);
                if (strategy == null) {
                    return Mono.just((Object)baseUrl);
                }
                return chain.resolveResource(null, (String)baseUrl, locations).flatMap(resource -> strategy.getResourceVersion((Resource)resource).map(version -> strategy.addVersion((String)baseUrl, (String)version)));
            }
            return Mono.empty();
        });
    }

    @Nullable
    protected VersionStrategy getStrategyForPath(String requestPath) {
        String path = "/".concat(requestPath);
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern : this.versionStrategyMap.keySet()) {
            if (!this.pathMatcher.match(pattern, path)) continue;
            matchingPatterns.add(pattern);
        }
        if (!matchingPatterns.isEmpty()) {
            Comparator comparator = this.pathMatcher.getPatternComparator(path);
            matchingPatterns.sort(comparator);
            return this.versionStrategyMap.get(matchingPatterns.get(0));
        }
        return null;
    }

    private static class FileNameVersionedResource
    extends AbstractResource
    implements HttpResource {
        private final Resource original;
        private final String version;

        public FileNameVersionedResource(Resource original, String version) {
            this.original = original;
            this.version = version;
        }

        public boolean exists() {
            return this.original.exists();
        }

        public boolean isReadable() {
            return this.original.isReadable();
        }

        public boolean isOpen() {
            return this.original.isOpen();
        }

        public boolean isFile() {
            return this.original.isFile();
        }

        public URL getURL() throws IOException {
            return this.original.getURL();
        }

        public URI getURI() throws IOException {
            return this.original.getURI();
        }

        public File getFile() throws IOException {
            return this.original.getFile();
        }

        public InputStream getInputStream() throws IOException {
            return this.original.getInputStream();
        }

        public ReadableByteChannel readableChannel() throws IOException {
            return this.original.readableChannel();
        }

        public byte[] getContentAsByteArray() throws IOException {
            return this.original.getContentAsByteArray();
        }

        public String getContentAsString(Charset charset) throws IOException {
            return this.original.getContentAsString(charset);
        }

        public long contentLength() throws IOException {
            return this.original.contentLength();
        }

        public long lastModified() throws IOException {
            return this.original.lastModified();
        }

        public Resource createRelative(String relativePath) throws IOException {
            return this.original.createRelative(relativePath);
        }

        @Nullable
        public String getFilename() {
            return this.original.getFilename();
        }

        public String getDescription() {
            return this.original.getDescription();
        }

        @Override
        public HttpHeaders getResponseHeaders() {
            HttpHeaders httpHeaders;
            Resource resource = this.original;
            if (resource instanceof HttpResource) {
                HttpResource httpResource = (HttpResource)resource;
                httpHeaders = httpResource.getResponseHeaders();
            } else {
                httpHeaders = new HttpHeaders();
            }
            HttpHeaders headers = httpHeaders;
            headers.setETag("W/\"" + this.version + "\"");
            return headers;
        }
    }
}

