/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.VFSRuntimeException;
import org.tinygroup.vfs.impl.FileSchemaProvider;
import org.tinygroup.vfs.impl.FtpSchemaProvider;
import org.tinygroup.vfs.impl.HttpSchemaProvider;
import org.tinygroup.vfs.impl.HttpsSchemaProvider;
import org.tinygroup.vfs.impl.JBossVfsSchemaProvider;
import org.tinygroup.vfs.impl.JarSchemaProvider;
import org.tinygroup.vfs.impl.WsJarSchemaProvider;
import org.tinygroup.vfs.impl.ZipSchemaProvider;

public final class VFS {
    private static Map<String, FileObject> fileObjectCacheMap = new ConcurrentHashMap<String, FileObject>();
    private static Map<String, Long> fileModifyTimeMap = new ConcurrentHashMap<String, Long>();
    private static Map<String, SchemaProvider> schemaProviderMap = new HashMap<String, SchemaProvider>();
    private static String defaultSchema = "file:";

    private VFS() {
    }

    public static void clearCache() {
        for (FileObject fileObject : fileObjectCacheMap.values()) {
            fileObject.clean();
        }
        fileObjectCacheMap.clear();
        fileModifyTimeMap.clear();
        schemaProviderMap.clear();
    }

    public static void addSchemaProvider(SchemaProvider schemaProvider) {
        schemaProviderMap.put(schemaProvider.getSchema(), schemaProvider);
    }

    public static void setDefaultSchemaProvider(String schema) {
        defaultSchema = schema;
    }

    public static SchemaProvider getSchemaProvider(String schema) {
        return schemaProviderMap.get(schema);
    }

    public static FileObject resolveFile(String resourceResolve) {
        long newTime;
        long oldTime22;
        String resource = resourceResolve;
        FileObject fileObject = fileObjectCacheMap.get(resource);
        if (fileObject != null && fileObject.isInPackage() && (oldTime22 = fileModifyTimeMap.get(resource).longValue()) == (newTime = fileObject.getLastModifiedTime())) {
            return fileObject;
        }
        try {
            resource = URLDecoder.decode(resource, "UTF-8");
        }
        catch (UnsupportedEncodingException oldTime22) {
            // empty catch block
        }
        SchemaProvider schemaProvider = schemaProviderMap.get(defaultSchema);
        for (SchemaProvider provider : schemaProviderMap.values()) {
            if (!provider.isMatch(resource)) continue;
            schemaProvider = provider;
            break;
        }
        if ((fileObject = schemaProvider.resolver(resource)) != null && fileObject.isInPackage()) {
            fileObjectCacheMap.put(resource, fileObject);
            fileModifyTimeMap.put(resource, fileObject.getLastModifiedTime());
        }
        return fileObject;
    }

    public static FileObject resolveURL(URL url) {
        return VFS.resolveFile(url.getPath());
    }

    public static void closeInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new VFSRuntimeException("inputStream\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25", e);
        }
    }

    public static void closeOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new VFSRuntimeException("outputStream\u8f93\u51fa\u6d41\u5173\u95ed\u5931\u8d25", e);
        }
    }

    static {
        VFS.addSchemaProvider(new JarSchemaProvider());
        VFS.addSchemaProvider(new WsJarSchemaProvider());
        VFS.addSchemaProvider(new ZipSchemaProvider());
        VFS.addSchemaProvider(new FileSchemaProvider());
        VFS.addSchemaProvider(new HttpSchemaProvider());
        VFS.addSchemaProvider(new HttpsSchemaProvider());
        VFS.addSchemaProvider(new JBossVfsSchemaProvider());
        VFS.addSchemaProvider(new FtpSchemaProvider());
    }
}

