/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl;

import java.util.List;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.FileObjectFilter;
import org.tinygroup.vfs.FileObjectProcessor;
import org.tinygroup.vfs.SchemaProvider;

public abstract class AbstractFileObject
implements FileObject {
    private SchemaProvider schemaProvider;
    private FileObject parent;

    public AbstractFileObject(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    @Override
    public FileObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(FileObject parent) {
        this.parent = parent;
    }

    @Override
    public SchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void resetModified() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FileObject) {
            FileObject fileObject = (FileObject)obj;
            return this.getAbsolutePath().equalsIgnoreCase(fileObject.getAbsolutePath());
        }
        return false;
    }

    @Override
    public void foreach(FileObjectFilter fileObjectFilter, FileObjectProcessor fileObjectProcessor, boolean parentFirst) {
        if (parentFirst && fileObjectFilter.accept(this)) {
            fileObjectProcessor.process(this);
        }
        if (this.isFolder()) {
            for (FileObject subFileObject : this.getChildren()) {
                subFileObject.foreach(fileObjectFilter, fileObjectProcessor, parentFirst);
            }
        }
        if (!parentFirst && fileObjectFilter.accept(this)) {
            fileObjectProcessor.process(this);
        }
    }

    @Override
    public void foreach(FileObjectFilter fileObjectFilter, FileObjectProcessor fileObjectProcessor) {
        this.foreach(fileObjectFilter, fileObjectProcessor, true);
    }

    @Override
    public void clean() {
    }

    @Override
    public void delete() {
        throw new RuntimeException("\u672cFileObject\u5b9e\u73b0\u4e0d\u652f\u6301delete\u64cd\u4f5c!");
    }

    @Override
    public FileObject getFileObject(String path) {
        if (path.equals("/")) {
            return this;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pathLayers = path.split("/");
        if (this.isFolder()) {
            List<FileObject> fileObjects = this.getChildren();
            for (FileObject subFileObject : fileObjects) {
                if (!subFileObject.getFileName().equals(pathLayers[0])) continue;
                if (pathLayers.length > 1) {
                    return subFileObject.getFileObject(this.substringAfter(path, "/"));
                }
                return subFileObject;
            }
        }
        return null;
    }

    public String substringAfter(String str, String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos >= 0) {
            return str.substring(pos + separator.length());
        }
        return "";
    }
}

