/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPReply;
import org.tinygroup.exception.TinySysRuntimeException;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.VFSRuntimeException;
import org.tinygroup.vfs.impl.FtpFileFilterByName;
import org.tinygroup.vfs.impl.URLFileObject;

public class FtpFileObject
extends URLFileObject {
    public static final int BUF_SIZE = 102400;
    private FTPFile ftpFile;
    private FTPClient ftpClient;

    private FtpFileObject(SchemaProvider schemaProvider) {
        super(schemaProvider);
    }

    public FtpFileObject(SchemaProvider schemaProvider, String resource) {
        super(schemaProvider, resource);
        this.connectFtpServer();
        this.initFTPFile();
    }

    private void connectFtpServer() {
        try {
            this.ftpClient = new FTPClient();
            FTPClientConfig ftpClientConfig = new FTPClientConfig();
            ftpClientConfig.setServerTimeZoneId(TimeZone.getDefault().getID());
            this.ftpClient.configure(ftpClientConfig);
            URL url = this.getURL();
            if (url.getPort() <= 0) {
                this.ftpClient.connect(url.getHost());
            } else {
                this.ftpClient.connect(url.getHost(), url.getPort());
            }
            if (!FTPReply.isPositiveCompletion((int)this.ftpClient.getReplyCode())) {
                throw new VFSRuntimeException("\u8fde\u63a5\u5931\u8d25\uff01");
            }
            if (url.getUserInfo() != null) {
                String[] userInfo = url.getUserInfo().split(":");
                String userName = null;
                String password = null;
                if (userInfo.length >= 1) {
                    userName = userInfo[0];
                }
                if (userInfo.length >= 2) {
                    password = userInfo[1];
                }
                if (!this.ftpClient.login(userName, password)) {
                    throw new VFSRuntimeException("\u767b\u5f55\u5931\u8d25\uff1a" + url.toString());
                }
                if (!this.ftpClient.setFileType(2)) {
                    throw new VFSRuntimeException("\u8bbe\u7f6e\u4e8c\u8fdb\u5236\u7c7b\u578b\u5931\u8d25");
                }
                this.ftpClient.setBufferSize(102400);
                this.ftpClient.setControlEncoding("utf-8");
            }
        }
        catch (Exception e) {
            throw new VFSRuntimeException(e);
        }
    }

    private void initFTPFile() {
        try {
            String checkPath;
            String path = this.getURL().getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.lastIndexOf(47));
            }
            if ((checkPath = path.substring(0, path.lastIndexOf(47))).length() == 0) {
                checkPath = "/";
            }
            String fileName = path.substring(path.lastIndexOf(47));
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            this.ftpClient.enterLocalPassiveMode();
            FTPFile[] files = this.ftpClient.listFiles(this.recode(checkPath), (FTPFileFilter)new FtpFileFilterByName(fileName));
            if (files == null || files.length != 1) {
                throw new TinySysRuntimeException("\u67e5\u627e\u8d44\u6e90\u5931\u8d25\uff0curl=" + this.getURL(), new Object[0]);
            }
            this.ftpFile = files[0];
        }
        catch (Exception e) {
            throw new VFSRuntimeException(e);
        }
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    @Override
    public String getAbsolutePath() {
        if (this.getURL() != null) {
            return this.getURL().getPath();
        }
        String parentAbsolutePath = this.getParent().getAbsolutePath();
        if (parentAbsolutePath.endsWith("/")) {
            return parentAbsolutePath + this.ftpFile.getName();
        }
        return parentAbsolutePath + "/" + this.ftpFile.getName();
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            if (this.getParent() != null) {
                super.setPath(this.getParent().getPath() + "/" + this.getFileName());
            } else {
                if (this.ftpFile.isDirectory()) {
                    return "";
                }
                return "/" + this.ftpFile.getName();
            }
        }
        return this.path;
    }

    @Override
    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = this.ftpFile.getName();
        }
        return this.fileName;
    }

    @Override
    public boolean isFolder() {
        return !this.ftpFile.isFile();
    }

    @Override
    public long getLastModifiedTime() {
        return this.ftpFile.getTimestamp().getTimeInMillis();
    }

    @Override
    public long getSize() {
        if (this.getFileSize() > 0L) {
            return this.getFileSize();
        }
        if (this.isFolder()) {
            return 0L;
        }
        this.setFileSize(this.ftpFile.getSize());
        return this.getFileSize();
    }

    @Override
    public InputStream getInputStream() {
        if (this.isFolder()) {
            return null;
        }
        InputStream is = null;
        try {
            String remote = this.getAbsolutePath();
            remote = this.recode(remote);
            is = this.ftpClient.retrieveFileStream(remote);
        }
        catch (IOException e) {
            throw new VFSRuntimeException("\u83b7\u53d6\u8f93\u5165\u6d41\u5f02\u5e38", e);
        }
        return is;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.isFolder()) {
            return null;
        }
        OutputStream os = null;
        try {
            String remote = this.getAbsolutePath();
            remote = this.recode(remote);
            os = this.ftpClient.storeFileStream(remote);
        }
        catch (IOException e) {
            throw new VFSRuntimeException(e);
        }
        return os;
    }

    @Override
    public List<FileObject> getChildren() {
        if (!this.isFolder()) {
            return null;
        }
        try {
            String pathname = this.getAbsolutePath();
            FTPFile[] files = this.ftpClient.listFiles(this.recode(pathname));
            ArrayList<FileObject> fileObjects = new ArrayList<FileObject>();
            for (FTPFile file : files) {
                FtpFileObject fileObject = new FtpFileObject(this.getSchemaProvider());
                fileObject.setParent(this);
                fileObject.ftpFile = file;
                fileObject.ftpClient = this.ftpClient;
                fileObjects.add(fileObject);
            }
            return fileObjects;
        }
        catch (IOException e) {
            throw new VFSRuntimeException(e);
        }
    }

    private String recode(String str) {
        String recode = str;
        try {
            recode = new String(str.getBytes("UTF-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return recode;
    }
}

