/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl;

import java.io.File;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.impl.AbstractSchemaProvider;
import org.tinygroup.vfs.impl.JarFileObject;

public class JarSchemaProvider
extends AbstractSchemaProvider {
    public static final String JAR = ".jar";
    public static final String JAR_PROTOCOL = "jar:";

    @Override
    public FileObject resolver(String resourceResolve) {
        return new JarFileObject(this, this.getResourceResolve(resourceResolve, JAR_PROTOCOL));
    }

    @Override
    public boolean isMatch(String resource) {
        String lowerCase = resource.toLowerCase();
        return lowerCase.startsWith(JAR_PROTOCOL) || lowerCase.endsWith(JAR) && new File(resource).exists();
    }

    @Override
    public String getSchema() {
        return JAR_PROTOCOL;
    }
}

