/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tinygroup.vfs.VFSRuntimeException;

public class SftpClient {
    private Log logger = LogFactory.getLog(SftpClient.class);
    private URL url;
    private Session session = null;
    private ChannelSftp channel = null;
    private String host;
    private int port;
    private int timeout = 30000;
    private String privKey = "";
    private String username;
    private String password;

    public SftpClient(URL url) {
        this.url = url;
        this.host = url.getHost();
        this.port = url.getPort();
        if (url.getUserInfo() != null) {
            String[] userInfo = url.getUserInfo().split(":");
            if (userInfo.length >= 1) {
                this.username = userInfo[0];
            }
            if (userInfo.length >= 2) {
                this.password = userInfo[1];
            }
        }
    }

    public void login() {
        try {
            JSch jsch = new JSch();
            if (StringUtils.isNotBlank((String)this.privKey)) {
                jsch.addIdentity(this.privKey);
            }
            this.session = this.port > 0 ? jsch.getSession(this.username, this.host, this.port) : jsch.getSession(this.username, this.host);
            if (this.password != null) {
                this.session.setPassword(this.password);
            }
            if (this.session == null) {
                throw new VFSRuntimeException("\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff1a" + this.url.toString());
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.setTimeout(this.timeout);
            this.session.connect();
            this.logger.debug((Object)"sftp session connected");
            this.logger.debug((Object)"opening channel");
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            this.channel.connect();
            this.logger.debug((Object)"connected successfully");
        }
        catch (JSchException e) {
            this.logger.error((Object)"sftp login failed", (Throwable)e);
            throw new VFSRuntimeException("\u5efa\u7acbSFTP\u901a\u9053\u5931\u8d25\uff1a" + this.url.toString());
        }
    }

    public InputStream getInputStream(String fileName) throws SftpException {
        return this.channel.get(fileName);
    }

    public OutputStream getOutputStream(String fileName) throws SftpException {
        return this.channel.put(fileName, 0);
    }

    public boolean changeDir(String pathName) {
        if (pathName == null || pathName.trim().equals("")) {
            this.logger.debug((Object)"invalid pathName");
            return false;
        }
        try {
            this.channel.cd(pathName.replaceAll("\\\\", "/"));
            this.logger.debug((Object)("directory successfully changed,current dir=" + this.channel.pwd()));
            return true;
        }
        catch (SftpException e) {
            this.logger.error((Object)"failed to change directory", (Throwable)e);
            return false;
        }
    }

    public boolean changeToParentDir() {
        return this.changeDir("..");
    }

    public boolean changeToHomeDir() {
        String homeDir = null;
        try {
            homeDir = this.channel.getHome();
        }
        catch (SftpException e) {
            this.logger.error((Object)"can not get home directory", (Throwable)e);
            return false;
        }
        return this.changeDir(homeDir);
    }

    public boolean makeDir(String dirName) {
        try {
            this.channel.mkdir(dirName);
            this.logger.debug((Object)("directory successfully created,dir=" + dirName));
            return true;
        }
        catch (SftpException e) {
            this.logger.error((Object)"failed to create directory", (Throwable)e);
            return false;
        }
    }

    public boolean delDir(String dirName) {
        if (!this.changeDir(dirName)) {
            return false;
        }
        Vector list = null;
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            this.logger.error((Object)"can not list directory", (Throwable)e);
            return false;
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (fileName.equals(".") || fileName.equals("..")) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.changeToParentDir()) {
            return false;
        }
        try {
            this.channel.rmdir(dirName);
            this.logger.debug((Object)("directory " + dirName + " successfully deleted"));
            return true;
        }
        catch (SftpException e) {
            this.logger.error((Object)("failed to delete directory " + dirName), (Throwable)e);
            return false;
        }
    }

    public boolean delFile(String fileName) {
        if (fileName == null || fileName.trim().equals("")) {
            this.logger.debug((Object)"invalid filename");
            return false;
        }
        try {
            this.channel.rm(fileName);
            this.logger.debug((Object)("file " + fileName + " successfully deleted"));
            return true;
        }
        catch (SftpException e) {
            this.logger.error((Object)("failed to delete file " + fileName), (Throwable)e);
            return false;
        }
    }

    public ChannelSftp.LsEntry[] ls() {
        return this.list(Filter.ALL);
    }

    public ChannelSftp.LsEntry[] ls(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new ChannelSftp.LsEntry[0];
        }
        ChannelSftp.LsEntry[] result = this.list(Filter.ALL);
        if (!this.changeDir(currentDir)) {
            return new ChannelSftp.LsEntry[0];
        }
        return result;
    }

    public ChannelSftp.LsEntry[] lsFiles() {
        return this.list(Filter.FILE);
    }

    public ChannelSftp.LsEntry[] lsFiles(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new ChannelSftp.LsEntry[0];
        }
        ChannelSftp.LsEntry[] result = this.list(Filter.FILE);
        if (!this.changeDir(currentDir)) {
            return new ChannelSftp.LsEntry[0];
        }
        return result;
    }

    public ChannelSftp.LsEntry[] lsDirs() {
        return this.list(Filter.DIR);
    }

    public ChannelSftp.LsEntry[] lsDirs(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new ChannelSftp.LsEntry[0];
        }
        ChannelSftp.LsEntry[] result = this.list(Filter.DIR);
        if (!this.changeDir(currentDir)) {
            return new ChannelSftp.LsEntry[0];
        }
        return result;
    }

    public ChannelSftp.LsEntry getEntry(String pathName, String fileName) {
        ChannelSftp.LsEntry[] list;
        if (!this.changeDir(pathName)) {
            return null;
        }
        if (!this.exist(fileName)) {
            return null;
        }
        for (ChannelSftp.LsEntry entry : list = this.ls()) {
            if (!entry.getFilename().equalsIgnoreCase(fileName)) continue;
            return entry;
        }
        return null;
    }

    public boolean exist(String name) {
        return this.exist(this.ls(), name);
    }

    public boolean exist(String path, String name) {
        return this.exist(this.ls(path), name);
    }

    public boolean existFile(String name) {
        return this.exist(this.lsFiles(), name);
    }

    public boolean existFile(String path, String name) {
        return this.exist(this.lsFiles(path), name);
    }

    public boolean existDir(String name) {
        return this.exist(this.lsDirs(), name);
    }

    public boolean existDir(String path, String name) {
        return this.exist(this.lsDirs(path), name);
    }

    public String currentDir() {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            this.logger.error((Object)"failed to get current dir", (Throwable)e);
            return this.homeDir();
        }
    }

    public void logout() {
        if (this.channel != null) {
            this.channel.quit();
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        this.logger.debug((Object)"logout successfully");
    }

    public boolean upload(String fileName, InputStream is) {
        try {
            this.channel.put(is, fileName, 0);
            this.logger.debug((Object)"upload successful");
            return true;
        }
        catch (SftpException e) {
            this.logger.error((Object)"upload failed", (Throwable)e);
            return false;
        }
    }

    public boolean download(String fileName, OutputStream os) {
        try {
            this.channel.get(fileName, os);
            this.logger.debug((Object)"download successful");
            return true;
        }
        catch (SftpException e) {
            this.logger.error((Object)"download file failed", (Throwable)e);
            return false;
        }
    }

    private ChannelSftp.LsEntry[] list(Filter filter) {
        Vector list = null;
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            this.logger.error((Object)"can not list directory", (Throwable)e);
            return new ChannelSftp.LsEntry[0];
        }
        ArrayList<ChannelSftp.LsEntry> resultList = new ArrayList<ChannelSftp.LsEntry>();
        for (ChannelSftp.LsEntry entry : list) {
            if (!this.filter(entry, filter)) continue;
            resultList.add(entry);
        }
        return resultList.toArray(new ChannelSftp.LsEntry[0]);
    }

    private boolean filter(ChannelSftp.LsEntry entry, Filter f) {
        if (f.equals((Object)Filter.ALL)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..");
        }
        if (f.equals((Object)Filter.FILE)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && !entry.getAttrs().isDir();
        }
        if (f.equals((Object)Filter.DIR)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && entry.getAttrs().isDir();
        }
        return false;
    }

    private String homeDir() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            return "/";
        }
    }

    private boolean exist(ChannelSftp.LsEntry[] files, String str) {
        if (files == null || files.length == 0) {
            return false;
        }
        if (str == null || str.trim().equals("")) {
            return false;
        }
        for (ChannelSftp.LsEntry entry : files) {
            if (!entry.getFilename().equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private static enum Filter {
        ALL,
        FILE,
        DIR;

    }
}

