/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.FileObjectFilter;
import org.tinygroup.vfs.FileObjectProcessor;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.VFSRuntimeException;
import org.tinygroup.vfs.impl.sftp.IFileObject;
import org.tinygroup.vfs.impl.sftp.SftpClient;

public class SftpFileObject
implements IFileObject {
    private static final long serialVersionUID = -79355183041937821L;
    private SchemaProvider schemaProvider;
    private FileObject parent;
    private URL url;
    private SftpClient sftpClient;
    private String absolutePath;
    private String absoluteDir;
    private String path;
    private String fileName;
    private String extName;
    private ChannelSftp.LsEntry entry;

    public SftpFileObject(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    public SftpFileObject(SchemaProvider schemaProvider, String resource) {
        try {
            this.schemaProvider = schemaProvider;
            this.url = new URL(null, resource, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return null;
                }
            });
            this.connectSftpServer();
            this.initRoot();
        }
        catch (MalformedURLException e) {
            throw new VFSRuntimeException("\u4e0d\u80fd\u5b9a\u4f4d\u5230\u8d44\u6e90:" + resource, e);
        }
    }

    @Override
    public SchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void resetModified() {
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getExtName() {
        if (this.extName == null) {
            int lastIndex = this.fileName.lastIndexOf(46);
            this.extName = lastIndex != -1 ? this.fileName.substring(lastIndex + 1) : "";
        }
        return this.extName;
    }

    @Override
    public boolean isFolder() {
        if (this.isExist()) {
            return this.entry.getAttrs().isDir();
        }
        throw new VFSRuntimeException("\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5224\u65ad\u662f\u5426\u662f\u6587\u4ef6\u5939\uff01");
    }

    @Override
    public boolean isInPackage() {
        return false;
    }

    @Override
    public boolean isExist() {
        return this.entry != null;
    }

    @Override
    public long getLastModifiedTime() {
        if (this.isExist()) {
            return 1000L * (long)this.entry.getAttrs().getMTime();
        }
        throw new VFSRuntimeException("\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u83b7\u53d6\u6700\u540e\u4fee\u6539\u65f6\u95f4\uff01");
    }

    @Override
    public long getSize() {
        if (this.isExist()) {
            return this.entry.getAttrs().getSize();
        }
        throw new VFSRuntimeException("\u8d44\u6e90\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u83b7\u53d6\u8d44\u6e90\u5927\u5c0f\uff01");
    }

    @Override
    public InputStream getInputStream() {
        if (!this.isExist() || this.isFolder()) {
            throw new VFSRuntimeException("\u8be5\u8d44\u6e90\u4e0d\u5b58\u5728\u6216\u662f\u6587\u4ef6\u5939");
        }
        InputStream is = null;
        try {
            this.sftpClient.changeDir(this.absoluteDir);
            is = this.sftpClient.getInputStream(this.fileName);
        }
        catch (SftpException e) {
            throw new VFSRuntimeException("\u83b7\u53d6\u8f93\u5165\u6d41\u5f02\u5e38", (Exception)((Object)e));
        }
        return is;
    }

    @Override
    public OutputStream getOutputStream() {
        this.makePathDirs();
        OutputStream os = null;
        try {
            this.sftpClient.changeDir(this.absoluteDir);
            os = this.sftpClient.getOutputStream(this.fileName);
        }
        catch (SftpException e) {
            throw new VFSRuntimeException("\u83b7\u53d6\u8f93\u5165\u6d41\u5f02\u5e38", (Exception)((Object)e));
        }
        return os;
    }

    @Override
    public FileObject getParent() {
        if (this.parent == null && !"/".equals(this.absoluteDir)) {
            SftpFileObject sfo = new SftpFileObject(this.schemaProvider);
            sfo.sftpClient = this.sftpClient;
            sfo.absolutePath = this.absoluteDir;
            sfo.absoluteDir = this.getDirPath(sfo.absolutePath);
            sfo.fileName = this.getFilePath(sfo.absolutePath);
            sfo.entry = this.sftpClient.getEntry(sfo.absoluteDir, sfo.fileName);
            sfo.path = !this.isExist() || this.isFolder() ? this.path + "../" : this.getDirPath(this.path) + "/";
            this.setParent(sfo);
        }
        return this.parent;
    }

    @Override
    public void setParent(FileObject fileObject) {
        this.parent = fileObject;
    }

    @Override
    public List<FileObject> getChildren() {
        if (!this.isExist()) {
            return null;
        }
        if (!this.isFolder()) {
            return null;
        }
        this.sftpClient.changeDir(this.absolutePath);
        ChannelSftp.LsEntry[] files = this.sftpClient.ls();
        ArrayList<FileObject> sfos = new ArrayList<FileObject>();
        for (ChannelSftp.LsEntry file : files) {
            SftpFileObject sfo = new SftpFileObject(this.getSchemaProvider());
            sfo.setParent(this);
            sfo.sftpClient = this.sftpClient;
            sfo.absoluteDir = this.absolutePath;
            sfo.absolutePath = "/".equals(this.absolutePath) ? this.absolutePath + file.getFilename() : this.absolutePath + "/" + file.getFilename();
            sfo.fileName = file.getFilename();
            sfo.entry = file;
            sfo.path = this.path.endsWith("/") ? this.path + file.getFilename() : this.path + "/" + file.getFilename();
            sfos.add(sfo);
        }
        return sfos;
    }

    @Override
    public FileObject getChild(String fileName) {
        List<FileObject> child = this.getChildren();
        if (child == null || child.size() == 0) {
            return null;
        }
        for (FileObject fo : this.getChildren()) {
            if (!fo.getFileName().equals(fileName)) continue;
            return fo;
        }
        return null;
    }

    @Override
    public void foreach(FileObjectFilter fileObjectFilter, FileObjectProcessor fileObjectProcessor, boolean parentFirst) {
        if (parentFirst && fileObjectFilter.accept(this)) {
            fileObjectProcessor.process(this);
        }
        if (this.isFolder()) {
            for (FileObject subFileObject : this.getChildren()) {
                subFileObject.foreach(fileObjectFilter, fileObjectProcessor, parentFirst);
            }
        }
        if (!parentFirst && fileObjectFilter.accept(this)) {
            fileObjectProcessor.process(this);
        }
    }

    @Override
    public void foreach(FileObjectFilter fileObjectFilter, FileObjectProcessor fileObjectProcessor) {
        this.foreach(fileObjectFilter, fileObjectProcessor, true);
    }

    @Override
    public void clean() {
        this.sftpClient.logout();
    }

    @Override
    public FileObject getFileObject(String path) {
        if (path.equals("/")) {
            return this;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pathLayers = path.split("/");
        if (this.isFolder()) {
            List<FileObject> fileObjects = this.getChildren();
            for (FileObject subFileObject : fileObjects) {
                if (!subFileObject.getFileName().equals(pathLayers[0])) continue;
                if (pathLayers.length > 1) {
                    return subFileObject.getFileObject(this.substringAfter(path, "/"));
                }
                return subFileObject;
            }
        }
        return null;
    }

    @Override
    public void upload(InputStream in) {
        if (this.isExist() && this.isFolder()) {
            throw new VFSRuntimeException("\u8be5\u8d44\u6e90\u662f\u6587\u4ef6\u5939\uff0c\u65e0\u6cd5\u4e0a\u4f20\u5185\u5bb9\uff01");
        }
        this.makePathDirs();
        this.sftpClient.changeDir(this.absoluteDir);
        this.sftpClient.upload(this.fileName, in);
    }

    @Override
    public void upload(String sourceFile) {
        try {
            this.upload(new FileInputStream(sourceFile));
        }
        catch (FileNotFoundException e) {
            throw new VFSRuntimeException("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u6d41\u5931\u8d25", e);
        }
    }

    @Override
    public void upload(File sourceFile) {
        try {
            this.upload(new FileInputStream(sourceFile));
        }
        catch (FileNotFoundException e) {
            throw new VFSRuntimeException("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u6d41\u5931\u8d25", e);
        }
    }

    @Override
    public void download(OutputStream out) {
        if (!this.isExist() || this.isFolder()) {
            throw new VFSRuntimeException("\u8be5\u8d44\u6e90\u4e0d\u5b58\u5728\u6216\u662f\u6587\u4ef6\u5939");
        }
        this.sftpClient.changeDir(this.absoluteDir);
        this.sftpClient.download(this.fileName, out);
    }

    @Override
    public void download(String dstFile) {
        this.download(new File(dstFile));
    }

    @Override
    public void download(File dstFile) {
        try {
            if (!dstFile.exists()) {
                dstFile.getParentFile().mkdirs();
                dstFile.createNewFile();
            }
            this.download(new FileOutputStream(dstFile));
        }
        catch (FileNotFoundException e) {
            throw new VFSRuntimeException("\u83b7\u53d6\u4e0b\u8f7d\u4fdd\u5b58\u6587\u4ef6\u6d41\u5931\u8d25", e);
        }
        catch (IOException e) {
            throw new VFSRuntimeException("\u521b\u5efa\u6587\u4ef6\u6d41\u5931\u8d25", e);
        }
    }

    public String getAbsoluteDir() {
        return this.absoluteDir;
    }

    private void connectSftpServer() {
        URL url = this.getURL();
        this.sftpClient = new SftpClient(url);
        this.sftpClient.login();
    }

    private void initRoot() {
        try {
            String p = this.getURL().getPath();
            if (p.endsWith("/")) {
                p = p.substring(0, p.lastIndexOf(47));
            }
            String dir = this.getDirPath(p);
            this.absolutePath = this.recode(p);
            this.absoluteDir = this.recode(dir);
            this.fileName = this.getFilePath(p);
            this.fileName = this.recode(this.fileName);
            this.sftpClient.changeDir(this.absoluteDir);
            this.entry = this.sftpClient.getEntry(this.absoluteDir, this.fileName);
            this.path = "./";
            if (this.entry != null && !this.isFolder()) {
                this.path = this.path + this.fileName;
            }
        }
        catch (Exception e) {
            throw new VFSRuntimeException(e);
        }
    }

    private String recode(String str) {
        String recode = str;
        try {
            recode = new String(str.getBytes("UTF-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return recode;
    }

    private String getDirPath(String path) {
        String dir;
        if (path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        if ((dir = path.substring(0, path.lastIndexOf(47))).length() == 0) {
            dir = "/";
        }
        return dir;
    }

    private String getFilePath(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        String file = path.substring(path.lastIndexOf(47));
        file = file.substring(file.lastIndexOf(47) + 1);
        return file;
    }

    private String substringAfter(String str, String separator) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos >= 0) {
            return str.substring(pos + separator.length());
        }
        return "";
    }

    private void makePathDirs() {
        SftpFileObject fo;
        Stack<SftpFileObject> stack = new Stack<SftpFileObject>();
        for (fo = this; fo != null && !fo.isExist(); fo = (SftpFileObject)fo.getParent()) {
            stack.push(fo);
        }
        while (!stack.isEmpty()) {
            fo = (SftpFileObject)stack.pop();
            this.sftpClient.changeDir(fo.getAbsoluteDir());
            this.sftpClient.makeDir(fo.getFileName());
        }
    }

    @Override
    public void delete() {
        throw new RuntimeException("\u672cFileObject\u5b9e\u73b0\u4e0d\u652f\u6301delete\u64cd\u4f5c!");
    }
}

