/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.FileUtil;
import org.zeroturnaround.zip.IdentityNameMapper;
import org.zeroturnaround.zip.NameMapper;
import org.zeroturnaround.zip.ZipBreakException;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipException;
import org.zeroturnaround.zip.ZipInfoCallback;
import org.zeroturnaround.zip.transform.ZipEntryTransformer;
import org.zeroturnaround.zip.transform.ZipEntryTransformerEntry;

public final class ZipUtil {
    private static final String PATH_SEPARATOR = "/";
    public static final int DEFAULT_COMPRESSION_LEVEL = -1;
    private static final Logger log = LoggerFactory.getLogger((String)"org/zeroturnaround/zip/ZipUtil".replace('/', '.'));

    private ZipUtil() {
    }

    public static boolean containsEntry(File zip, String name) {
        boolean bl;
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            bl = zf.getEntry(name) != null;
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsAnyEntry(File zip, String[] names) {
        boolean bl;
        ZipFile zf;
        block6: {
            int i;
            zf = null;
            try {
                zf = new ZipFile(zip);
                for (i = 0; i < names.length; ++i) {
                    if (zf.getEntry(names[i]) == null) continue;
                    bl = true;
                    break block6;
                }
                i = 0;
            }
            catch (IOException e) {
                try {
                    throw ZipUtil.rethrow(e);
                }
                catch (Throwable throwable) {
                    ZipUtil.closeQuietly(zf);
                    throw throwable;
                }
            }
            ZipUtil.closeQuietly(zf);
            return i != 0;
        }
        ZipUtil.closeQuietly(zf);
        return bl;
    }

    public static byte[] unpackEntry(File zip, String name) {
        byte[] byArray;
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            byArray = ZipUtil.doUnpackEntry(zf, name);
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return byArray;
    }

    public static byte[] unpackEntry(ZipFile zf, String name) {
        try {
            return ZipUtil.doUnpackEntry(zf, name);
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doUnpackEntry(ZipFile zf, String name) throws IOException {
        ZipEntry ze = zf.getEntry(name);
        if (ze == null) {
            return null;
        }
        InputStream is = zf.getInputStream(ze);
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static byte[] unpackEntry(InputStream is, String name) {
        ByteArrayUnpacker action = new ByteArrayUnpacker();
        if (!ZipUtil.handle(is, name, (ZipEntryCallback)action)) {
            return null;
        }
        return action.getBytes();
    }

    public static boolean unpackEntry(File zip, String name, File file) {
        boolean bl;
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            bl = ZipUtil.doUnpackEntry(zf, name, file);
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return bl;
    }

    public static boolean unpackEntry(ZipFile zf, String name, File file) {
        try {
            return ZipUtil.doUnpackEntry(zf, name, file);
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doUnpackEntry(ZipFile zf, String name, File file) throws IOException {
        ZipEntry ze;
        if (log.isTraceEnabled()) {
            log.trace("Extracting '" + zf.getName() + "' entry '" + name + "' into '" + file + "'.");
        }
        if ((ze = zf.getEntry(name)) == null) {
            return false;
        }
        BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
        try {
            FileUtil.copy(in, file);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return true;
    }

    public static boolean unpackEntry(InputStream is, String name, File file) throws IOException {
        return ZipUtil.handle(is, name, (ZipEntryCallback)new FileUnpacker(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterate(File zip, ZipEntryCallback action) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                InputStream is = zf.getInputStream(e);
                try {
                    action.process(is, e);
                }
                catch (ZipBreakException ex) {
                    break;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterate(File zip, String[] entryNames, ZipEntryCallback action) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            for (int i = 0; i < entryNames.length; ++i) {
                ZipEntry e = zf.getEntry(entryNames[i]);
                if (e == null) continue;
                InputStream is = zf.getInputStream(e);
                try {
                    action.process(is, e);
                    continue;
                }
                catch (ZipBreakException ex) {
                    break;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
    }

    public static void iterate(File zip, ZipInfoCallback action) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                try {
                    action.process(e);
                }
                catch (ZipBreakException ex) {
                }
            }
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
    }

    public static void iterate(File zip, String[] entryNames, ZipInfoCallback action) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            for (int i = 0; i < entryNames.length; ++i) {
                ZipEntry e = zf.getEntry(entryNames[i]);
                if (e == null) continue;
                try {
                    action.process(e);
                    continue;
                }
                catch (ZipBreakException ex) {
                    break;
                }
            }
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
    }

    public static void iterate(InputStream is, ZipEntryCallback action) {
        try {
            ZipEntry entry;
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(is));
            while ((entry = in.getNextEntry()) != null) {
                try {
                    action.process(in, entry);
                }
                catch (ZipBreakException ex) {
                    break;
                }
            }
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    public static void iterate(InputStream is, String[] entryNames, ZipEntryCallback action) {
        HashSet<String> namesSet = new HashSet<String>();
        for (int i = 0; i < entryNames.length; ++i) {
            namesSet.add(entryNames[i]);
        }
        try {
            ZipEntry entry;
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(is));
            while ((entry = in.getNextEntry()) != null) {
                if (!namesSet.contains(entry.getName())) continue;
                try {
                    action.process(in, entry);
                }
                catch (ZipBreakException ex) {
                    break;
                }
            }
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handle(File zip, String name, ZipEntryCallback action) {
        boolean bl;
        ZipEntry ze;
        ZipFile zf;
        block8: {
            zf = null;
            zf = new ZipFile(zip);
            ze = zf.getEntry(name);
            if (ze != null) break block8;
            boolean bl2 = false;
            ZipUtil.closeQuietly(zf);
            return bl2;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
            try {
                action.process(in, ze);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            bl = true;
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return bl;
    }

    public static boolean handle(InputStream is, String name, ZipEntryCallback action) {
        SingleZipEntryCallback helper = new SingleZipEntryCallback(name, action);
        ZipUtil.iterate(is, (ZipEntryCallback)helper);
        return helper.found();
    }

    public static void unpack(File zip, File outputDir) {
        ZipUtil.unpack(zip, outputDir, IdentityNameMapper.INSTANCE);
    }

    public static void unpack(File zip, File outputDir, NameMapper mapper) {
        log.debug("Extracting '{}' into '{}'.", (Object)zip, (Object)outputDir);
        ZipUtil.iterate(zip, (ZipEntryCallback)new Unpacker(outputDir, mapper));
    }

    public static void unwrap(File zip, File outputDir) {
        ZipUtil.unwrap(zip, outputDir, IdentityNameMapper.INSTANCE);
    }

    public static void unwrap(File zip, File outputDir, NameMapper mapper) {
        log.debug("Unwraping '{}' into '{}'.", (Object)zip, (Object)outputDir);
        ZipUtil.iterate(zip, (ZipEntryCallback)new Unwraper(outputDir, mapper));
    }

    public static void unpack(InputStream is, File outputDir) {
        ZipUtil.unpack(is, outputDir, IdentityNameMapper.INSTANCE);
    }

    public static void unpack(InputStream is, File outputDir, NameMapper mapper) {
        log.debug("Extracting {} into '{}'.", (Object)is, (Object)outputDir);
        ZipUtil.iterate(is, (ZipEntryCallback)new Unpacker(outputDir, mapper));
    }

    public static void unwrap(InputStream is, File outputDir) {
        ZipUtil.unwrap(is, outputDir, IdentityNameMapper.INSTANCE);
    }

    public static void unwrap(InputStream is, File outputDir, NameMapper mapper) {
        log.debug("Unwraping {} into '{}'.", (Object)is, (Object)outputDir);
        ZipUtil.iterate(is, (ZipEntryCallback)new Unwraper(outputDir, mapper));
    }

    public static void explode(File zip) {
        try {
            File tempFile = FileUtil.getTempFileFor(zip);
            FileUtils.moveFile((File)zip, (File)tempFile);
            ZipUtil.unpack(tempFile, zip);
            if (!tempFile.delete()) {
                throw new IOException("Unable to delete file: " + tempFile);
            }
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packEntry(File file) {
        log.trace("Compressing '{}' into a ZIP file with single entry.", (Object)file);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            ZipOutputStream out = new ZipOutputStream(result);
            ZipEntry entry = new ZipEntry(file.getName());
            entry.setTime(file.lastModified());
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                ZipUtil.addEntry(entry, in, out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            out.close();
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
        return result.toByteArray();
    }

    public static void pack(File rootDir, File zip) {
        ZipUtil.pack(rootDir, zip, -1);
    }

    public static void pack(File rootDir, File zip, int compressionLevel) {
        ZipUtil.pack(rootDir, zip, IdentityNameMapper.INSTANCE, compressionLevel);
    }

    public static void pack(File sourceDir, File targetZipFile, boolean preserveRoot) {
        if (preserveRoot) {
            final String parentName = sourceDir.getName();
            ZipUtil.pack(sourceDir, targetZipFile, new NameMapper(){

                public String map(String name) {
                    return parentName + ZipUtil.PATH_SEPARATOR + name;
                }
            });
        } else {
            ZipUtil.pack(sourceDir, targetZipFile);
        }
    }

    public static void packEntry(File fileToPack, File destZipFile) {
        ZipUtil.packEntries(new File[]{fileToPack}, destZipFile);
    }

    public static void packEntries(File[] filesToPack, File destZipFile) {
        log.debug("Compressing '{}' into '{}'.", (Object)filesToPack, (Object)destZipFile);
        ZipOutputStream out = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destZipFile);
            out = new ZipOutputStream(new BufferedOutputStream(fos));
            for (int i = 0; i < filesToPack.length; ++i) {
                File fileToPack = filesToPack[i];
                ZipEntry zipEntry = new ZipEntry(fileToPack.getName());
                zipEntry.setSize(fileToPack.length());
                zipEntry.setTime(fileToPack.lastModified());
                out.putNextEntry(zipEntry);
                FileUtil.copy(fileToPack, out);
                out.closeEntry();
            }
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly((OutputStream)fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public static void pack(File sourceDir, File targetZip, NameMapper mapper) {
        ZipUtil.pack(sourceDir, targetZip, mapper, -1);
    }

    public static void pack(File sourceDir, File targetZip, NameMapper mapper, int compressionLevel) {
        log.debug("Compressing '{}' into '{}'.", (Object)sourceDir, (Object)targetZip);
        File[] listFiles = sourceDir.listFiles();
        if (listFiles == null) {
            if (!sourceDir.exists()) {
                throw new ZipException("Given file '" + sourceDir + "' doesn't exist!");
            }
            throw new ZipException("Given file '" + sourceDir + "' is not a directory!");
        }
        if (listFiles.length == 0) {
            throw new ZipException("Given directory '" + sourceDir + "' doesn't contain any files!");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetZip)));
            out.setLevel(compressionLevel);
            ZipUtil.pack(sourceDir, out, mapper, "");
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private static void pack(File dir, ZipOutputStream out, NameMapper mapper, String pathPrefix) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Given file is not a directory '" + dir + "'");
        }
        for (int i = 0; i < files.length; ++i) {
            String name;
            File file = files[i];
            boolean isDir = file.isDirectory();
            String path = pathPrefix + file.getName();
            if (isDir) {
                path = path + PATH_SEPARATOR;
            }
            if ((name = mapper.map(path)) != null) {
                ZipEntry zipEntry = new ZipEntry(name);
                if (!isDir) {
                    zipEntry.setSize(file.length());
                    zipEntry.setTime(file.lastModified());
                }
                out.putNextEntry(zipEntry);
                if (!isDir) {
                    FileUtil.copy(file, out);
                }
                out.closeEntry();
            }
            if (!isDir) continue;
            ZipUtil.pack(file, out, mapper, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(File srcZip, File dstZip, int compressionLevel) {
        log.debug("Repacking '{}' into '{}'.", (Object)srcZip, (Object)dstZip);
        RepackZipEntryCallback callback = new RepackZipEntryCallback(dstZip, compressionLevel);
        try {
            ZipUtil.iterate(srcZip, (ZipEntryCallback)callback);
        }
        finally {
            callback.closeStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(InputStream is, File dstZip, int compressionLevel) {
        log.debug("Repacking from input stream into '{}'.", (Object)dstZip);
        RepackZipEntryCallback callback = new RepackZipEntryCallback(dstZip, compressionLevel);
        try {
            ZipUtil.iterate(is, (ZipEntryCallback)callback);
        }
        finally {
            callback.closeStream();
        }
    }

    public static void repack(File zip, int compressionLevel) {
        try {
            File tmpZip = FileUtil.getTempFileFor(zip);
            ZipUtil.repack(zip, tmpZip, compressionLevel);
            if (!zip.delete()) {
                throw new IOException("Unable to delete the file: " + zip);
            }
            FileUtils.moveFile((File)tmpZip, (File)zip);
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    public static void unexplode(File dir) {
        ZipUtil.unexplode(dir, -1);
    }

    public static void unexplode(File dir, int compressionLevel) {
        try {
            File zip = FileUtil.getTempFileFor(dir);
            ZipUtil.pack(dir, zip, compressionLevel);
            FileUtils.deleteDirectory((File)dir);
            FileUtils.moveFile((File)zip, (File)dir);
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    public static void pack(ZipEntrySource[] entries, File zip) {
        log.debug("Creating '{}' from {}.", (Object)zip, Arrays.asList(entries));
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip)));
            for (int i = 0; i < entries.length; ++i) {
                ZipUtil.addEntry(entries[i], out);
            }
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static void addEntry(File zip, String path, File file, File destZip) {
        ZipUtil.addEntry(zip, new FileSource(path, file), destZip);
    }

    public static void addEntry(final File zip, final String path, final File file) {
        ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                ZipUtil.addEntry(zip, path, file, tmpFile);
                return true;
            }
        });
    }

    public static void addEntry(File zip, String path, byte[] bytes, File destZip) {
        ZipUtil.addEntry(zip, new ByteSource(path, bytes), destZip);
    }

    public static void addEntry(final File zip, final String path, final byte[] bytes) {
        ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                ZipUtil.addEntry(zip, path, bytes, tmpFile);
                return true;
            }
        });
    }

    public static void addEntry(File zip, ZipEntrySource entry, File destZip) {
        ZipUtil.addEntries(zip, new ZipEntrySource[]{entry}, destZip);
    }

    public static void addEntry(final File zip, final ZipEntrySource entry) {
        ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                ZipUtil.addEntry(zip, entry, tmpFile);
                return true;
            }
        });
    }

    public static void addEntries(File zip, ZipEntrySource[] entries, File destZip) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip + "' to '" + destZip + "' and adding " + Arrays.asList(entries) + ".");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
            ZipUtil.copyEntries(zip, out);
            for (int i = 0; i < entries.length; ++i) {
                ZipUtil.addEntry(entries[i], out);
            }
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static void addEntries(final File zip, final ZipEntrySource[] entries) {
        ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                ZipUtil.addEntries(zip, entries, tmpFile);
                return true;
            }
        });
    }

    public static void removeEntry(File zip, String path, File destZip) {
        ZipUtil.removeEntries(zip, new String[]{path}, destZip);
    }

    public static void removeEntry(final File zip, final String path) {
        ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                ZipUtil.removeEntry(zip, path, tmpFile);
                return true;
            }
        });
    }

    public static void removeEntries(File zip, String[] paths, File destZip) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip + "' to '" + destZip + "' and removing paths " + Arrays.asList(paths) + ".");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
            ZipUtil.copyEntries(zip, out, new HashSet<String>(Arrays.asList(paths)));
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static void removeEntries(final File zip, final String[] paths) {
        ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                ZipUtil.removeEntries(zip, paths, tmpFile);
                return true;
            }
        });
    }

    private static void copyEntries(File zip, final ZipOutputStream out) {
        final HashSet names = new HashSet();
        ZipUtil.iterate(zip, new ZipEntryCallback(){

            public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                String entryName = zipEntry.getName();
                if (names.add(entryName)) {
                    ZipUtil.copyEntry(zipEntry, in, out);
                } else if (log.isDebugEnabled()) {
                    log.debug("Duplicate entry: {}", (Object)entryName);
                }
            }
        });
    }

    private static void copyEntries(File zip, final ZipOutputStream out, final Set ignoredEntries) {
        final HashSet names = new HashSet();
        final Set dirNames = ZipUtil.filterDirEntries(zip, ignoredEntries);
        ZipUtil.iterate(zip, new ZipEntryCallback(){

            public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                String entryName = zipEntry.getName();
                if (ignoredEntries.contains(entryName)) {
                    return;
                }
                Iterator iter = dirNames.iterator();
                while (iter.hasNext()) {
                    String dirName = (String)iter.next();
                    if (!entryName.startsWith(dirName)) continue;
                    return;
                }
                if (names.add(entryName)) {
                    ZipUtil.copyEntry(zipEntry, in, out);
                } else if (log.isDebugEnabled()) {
                    log.debug("Duplicate entry: {}", (Object)entryName);
                }
            }
        });
    }

    static Set filterDirEntries(File zip, Collection names) {
        HashSet<String> dirs = new HashSet<String>();
        if (zip == null) {
            return dirs;
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip);
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String entryName = (String)iterator.next();
                ZipEntry entry = zf.getEntry(entryName);
                if (entry.isDirectory()) {
                    dirs.add(entry.getName());
                    continue;
                }
                if (zf.getInputStream(entry) != null) continue;
                dirs.add(entry.getName() + PATH_SEPARATOR);
            }
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return dirs;
    }

    public static boolean replaceEntry(File zip, String path, File file, File destZip) {
        return ZipUtil.replaceEntry(zip, new FileSource(path, file), destZip);
    }

    public static boolean replaceEntry(final File zip, final String path, final File file) {
        return ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntry(zip, new FileSource(path, file), tmpFile);
            }
        });
    }

    public static boolean replaceEntry(File zip, String path, byte[] bytes, File destZip) {
        return ZipUtil.replaceEntry(zip, new ByteSource(path, bytes), destZip);
    }

    public static boolean replaceEntry(final File zip, final String path, final byte[] bytes) {
        return ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntry(zip, new ByteSource(path, bytes), tmpFile);
            }
        });
    }

    public static boolean replaceEntry(File zip, ZipEntrySource entry, File destZip) {
        return ZipUtil.replaceEntries(zip, new ZipEntrySource[]{entry}, destZip);
    }

    public static boolean replaceEntry(final File zip, final ZipEntrySource entry) {
        return ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntry(zip, entry, tmpFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceEntries(File zip, ZipEntrySource[] entries, File destZip) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip + "' to '" + destZip + "' and replacing entries " + Arrays.asList(entries) + ".");
        }
        final Map entryByPath = ZipUtil.byPath(entries);
        int entryCount = entryByPath.size();
        try {
            final ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
            try {
                final HashSet names = new HashSet();
                ZipUtil.iterate(zip, new ZipEntryCallback(){

                    public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                        if (names.add(zipEntry.getName())) {
                            ZipEntrySource entry = (ZipEntrySource)entryByPath.remove(zipEntry.getName());
                            if (entry != null) {
                                ZipUtil.addEntry(entry, out);
                            } else {
                                ZipUtil.copyEntry(zipEntry, in, out);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Duplicate entry: {}", (Object)zipEntry.getName());
                        }
                    }
                });
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
        return entryByPath.size() < entryCount;
    }

    public static boolean replaceEntries(final File zip, final ZipEntrySource[] entries) {
        return ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntries(zip, entries, tmpFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrReplaceEntries(File zip, ZipEntrySource[] entries, File destZip) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip + "' to '" + destZip + "' and adding/replacing entries " + Arrays.asList(entries) + ".");
        }
        final Map entryByPath = ZipUtil.byPath(entries);
        try {
            final ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
            try {
                final HashSet names = new HashSet();
                ZipUtil.iterate(zip, new ZipEntryCallback(){

                    public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                        if (names.add(zipEntry.getName())) {
                            ZipEntrySource entry = (ZipEntrySource)entryByPath.remove(zipEntry.getName());
                            if (entry != null) {
                                ZipUtil.addEntry(entry, out);
                            } else {
                                ZipUtil.copyEntry(zipEntry, in, out);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Duplicate entry: {}", (Object)zipEntry.getName());
                        }
                    }
                });
                Iterator it = entryByPath.values().iterator();
                while (it.hasNext()) {
                    ZipUtil.addEntry((ZipEntrySource)it.next(), out);
                }
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    public static void addOrReplaceEntries(final File zip, final ZipEntrySource[] entries) {
        ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                ZipUtil.addOrReplaceEntries(zip, entries, tmpFile);
                return true;
            }
        });
    }

    static Map byPath(ZipEntrySource[] entries) {
        HashMap<String, ZipEntrySource> result = new HashMap<String, ZipEntrySource>();
        for (int i = 0; i < entries.length; ++i) {
            ZipEntrySource source = entries[i];
            result.put(source.getPath(), source);
        }
        return result;
    }

    static Map byPath(Collection entries) {
        HashMap<String, ZipEntrySource> result = new HashMap<String, ZipEntrySource>();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            ZipEntrySource source = (ZipEntrySource)iter.next();
            result.put(source.getPath(), source);
        }
        return result;
    }

    public static boolean transformEntry(File zip, String path, ZipEntryTransformer transformer, File destZip) {
        return ZipUtil.transformEntry(zip, new ZipEntryTransformerEntry(path, transformer), destZip);
    }

    public static boolean transformEntry(final File zip, final String path, final ZipEntryTransformer transformer) {
        return ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                return ZipUtil.transformEntry(zip, path, transformer, tmpFile);
            }
        });
    }

    public static boolean transformEntry(File zip, ZipEntryTransformerEntry entry, File destZip) {
        return ZipUtil.transformEntries(zip, new ZipEntryTransformerEntry[]{entry}, destZip);
    }

    public static boolean transformEntry(final File zip, final ZipEntryTransformerEntry entry) {
        return ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                return ZipUtil.transformEntry(zip, entry, tmpFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean transformEntries(File zip, ZipEntryTransformerEntry[] entries, File destZip) {
        boolean bl;
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip + "' to '" + destZip + "' and transforming entries " + Arrays.asList(entries) + ".");
        }
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
        try {
            TransformerZipEntryCallback action = new TransformerZipEntryCallback(entries, out);
            ZipUtil.iterate(zip, (ZipEntryCallback)action);
            bl = action.found();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
            catch (IOException e) {
                throw ZipUtil.rethrow(e);
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return bl;
    }

    public static boolean transformEntries(final File zip, final ZipEntryTransformerEntry[] entries) {
        return ZipUtil.operateInPlace(zip, new InPlaceAction(){

            public boolean act(File tmpFile) {
                return ZipUtil.transformEntries(zip, entries, tmpFile);
            }
        });
    }

    public static boolean transformEntry(InputStream is, String path, ZipEntryTransformer transformer, OutputStream os) {
        return ZipUtil.transformEntry(is, new ZipEntryTransformerEntry(path, transformer), os);
    }

    public static boolean transformEntry(InputStream is, ZipEntryTransformerEntry entry, OutputStream os) {
        return ZipUtil.transformEntries(is, new ZipEntryTransformerEntry[]{entry}, os);
    }

    public static boolean transformEntries(InputStream is, ZipEntryTransformerEntry[] entries, OutputStream os) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + is + "' to '" + os + "' and transforming entries " + Arrays.asList(entries) + ".");
        }
        try {
            ZipOutputStream out = new ZipOutputStream(os);
            TransformerZipEntryCallback action = new TransformerZipEntryCallback(entries, out);
            ZipUtil.iterate(is, (ZipEntryCallback)action);
            out.finish();
            return action.found();
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    static Map byPath(ZipEntryTransformerEntry[] entries) {
        HashMap<String, ZipEntryTransformer> result = new HashMap<String, ZipEntryTransformer>();
        for (int i = 0; i < entries.length; ++i) {
            ZipEntryTransformerEntry entry = entries[i];
            result.put(entry.getPath(), entry.getTransformer());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addEntry(ZipEntrySource entry, ZipOutputStream out) throws IOException {
        out.putNextEntry(entry.getEntry());
        InputStream in = entry.getInputStream();
        if (in != null) {
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        out.closeEntry();
    }

    static void addEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream out) throws IOException {
        out.putNextEntry(zipEntry);
        if (in != null) {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        out.closeEntry();
    }

    static void copyEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry copy = new ZipEntry(zipEntry.getName());
        copy.setTime(zipEntry.getTime());
        ZipUtil.addEntry(copy, new BufferedInputStream(in), out);
    }

    public static boolean archiveEquals(File f1, File f2) {
        try {
            if (FileUtils.contentEquals((File)f1, (File)f2)) {
                return true;
            }
            log.debug("Comparing archives '{}' and '{}'...", (Object)f1, (Object)f2);
            long start = System.currentTimeMillis();
            boolean result = ZipUtil.archiveEqualsInternal(f1, f2);
            long time = System.currentTimeMillis() - start;
            if (time > 0L) {
                log.debug("Archives compared in " + time + " ms.");
            }
            return result;
        }
        catch (Exception e) {
            log.debug("Could not compare '" + f1 + "' and '" + f2 + "':", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean archiveEqualsInternal(File f1, File f2) throws IOException {
        boolean bl;
        ZipEntry e2;
        String path;
        ZipEntry e1;
        ZipFile zf2;
        ZipFile zf1;
        block8: {
            zf1 = null;
            zf2 = null;
            zf1 = new ZipFile(f1);
            zf2 = new ZipFile(f2);
            if (zf1.size() == zf2.size()) break block8;
            log.debug("Number of entries changed (" + zf1.size() + " vs " + zf2.size() + ").");
            boolean bl2 = false;
            ZipUtil.closeQuietly(zf1);
            ZipUtil.closeQuietly(zf2);
            return bl2;
        }
        try {
            Enumeration<? extends ZipEntry> en = zf1.entries();
            while (en.hasMoreElements()) {
                e1 = en.nextElement();
                path = e1.getName();
                if (ZipUtil.metaDataEquals(path, e1, e2 = zf2.getEntry(path))) break block9;
                bl = false;
            }
        }
        catch (Throwable throwable) {
            ZipUtil.closeQuietly(zf1);
            ZipUtil.closeQuietly(zf2);
            throw throwable;
        }
        {
            InputStream is2;
            InputStream is1;
            block10: {
                block9: {
                    ZipUtil.closeQuietly(zf1);
                    ZipUtil.closeQuietly(zf2);
                    return bl;
                }
                is1 = null;
                is2 = null;
                is1 = zf1.getInputStream(e1);
                is2 = zf2.getInputStream(e2);
                if (IOUtils.contentEquals((InputStream)is1, (InputStream)is2)) break block10;
                log.debug("Entry '{}' content changed.", (Object)path);
                boolean bl3 = false;
                IOUtils.closeQuietly((InputStream)is1);
                IOUtils.closeQuietly((InputStream)is2);
                ZipUtil.closeQuietly(zf1);
                ZipUtil.closeQuietly(zf2);
                return bl3;
            }
            IOUtils.closeQuietly((InputStream)is1);
            IOUtils.closeQuietly((InputStream)is2);
            continue;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)is1);
                    IOUtils.closeQuietly(is2);
                    throw throwable;
                }
            }
        }
        ZipUtil.closeQuietly(zf1);
        ZipUtil.closeQuietly(zf2);
        log.debug("Archives are the same.");
        return true;
    }

    private static boolean metaDataEquals(String path, ZipEntry e1, ZipEntry e2) throws IOException {
        if (e2 == null) {
            log.debug("Entry '{}' removed.", (Object)path);
            return false;
        }
        if (e1.isDirectory()) {
            if (e2.isDirectory()) {
                return true;
            }
            log.debug("Entry '{}' not a directory any more.", (Object)path);
            return false;
        }
        if (e2.isDirectory()) {
            log.debug("Entry '{}' now a directory.", (Object)path);
            return false;
        }
        long size1 = e1.getSize();
        long size2 = e2.getSize();
        if (size1 != -1L && size2 != -1L && size1 != size2) {
            log.debug("Entry '" + path + "' size changed (" + size1 + " vs " + size2 + ").");
            return false;
        }
        long crc1 = e1.getCrc();
        long crc2 = e2.getCrc();
        if (crc1 != -1L && crc2 != -1L && crc1 != crc2) {
            log.debug("Entry '" + path + "' CRC changed (" + crc1 + " vs " + crc2 + ").");
            return false;
        }
        if (log.isTraceEnabled()) {
            long time1 = e1.getTime();
            long time2 = e2.getTime();
            if (time1 != -1L && time2 != -1L && time1 != time2) {
                log.trace("Entry '" + path + "' time changed (" + new Date(time1) + " vs " + new Date(time2) + ").");
            }
        }
        return true;
    }

    public static boolean entryEquals(File f1, File f2, String path) {
        return ZipUtil.entryEquals(f1, f2, path, path);
    }

    public static boolean entryEquals(File f1, File f2, String path1, String path2) {
        boolean bl;
        ZipFile zf1 = null;
        ZipFile zf2 = null;
        try {
            zf1 = new ZipFile(f1);
            zf2 = new ZipFile(f2);
            bl = ZipUtil.doEntryEquals(zf1, zf2, path1, path2);
        }
        catch (IOException e) {
            try {
                throw ZipUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf1);
                ZipUtil.closeQuietly(zf2);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf1);
        ZipUtil.closeQuietly(zf2);
        return bl;
    }

    public static boolean entryEquals(ZipFile zf1, ZipFile zf2, String path1, String path2) {
        try {
            return ZipUtil.doEntryEquals(zf1, zf2, path1, path2);
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doEntryEquals(ZipFile zf1, ZipFile zf2, String path1, String path2) throws IOException {
        InputStream is2;
        InputStream is1;
        block9: {
            block8: {
                ZipEntry e2;
                ZipEntry e1;
                block7: {
                    block6: {
                        boolean bl;
                        is1 = null;
                        is2 = null;
                        try {
                            e1 = zf1.getEntry(path1);
                            e2 = zf2.getEntry(path2);
                            if (e1 != null || e2 != null) break block6;
                            bl = true;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is1);
                            IOUtils.closeQuietly(is2);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(is1);
                        IOUtils.closeQuietly(is2);
                        return bl;
                    }
                    if (e1 != null && e2 != null) break block7;
                    boolean bl = false;
                    IOUtils.closeQuietly(is1);
                    IOUtils.closeQuietly(is2);
                    return bl;
                }
                is1 = zf1.getInputStream(e1);
                is2 = zf2.getInputStream(e2);
                if (is1 != null || is2 != null) break block8;
                boolean bl = true;
                IOUtils.closeQuietly((InputStream)is1);
                IOUtils.closeQuietly((InputStream)is2);
                return bl;
            }
            if (is1 != null && is2 != null) break block9;
            boolean bl = false;
            IOUtils.closeQuietly((InputStream)is1);
            IOUtils.closeQuietly((InputStream)is2);
            return bl;
        }
        boolean bl = IOUtils.contentEquals((InputStream)is1, (InputStream)is2);
        IOUtils.closeQuietly((InputStream)is1);
        IOUtils.closeQuietly((InputStream)is2);
        return bl;
    }

    public static void closeQuietly(ZipFile zf) {
        try {
            if (zf != null) {
                zf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static ZipException rethrow(IOException e) {
        throw new ZipException(e);
    }

    private static boolean operateInPlace(File src, InPlaceAction action) {
        File tmp = null;
        try {
            tmp = File.createTempFile("zt-zip-tmp", ".zip");
            boolean result = action.act(tmp);
            if (result) {
                FileUtils.forceDelete((File)src);
                FileUtils.moveFile((File)tmp, (File)src);
            }
            boolean bl = result;
            return bl;
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
        finally {
            FileUtils.deleteQuietly((File)tmp);
        }
    }

    private static abstract class InPlaceAction {
        private InPlaceAction() {
        }

        abstract boolean act(File var1);
    }

    private static class TransformerZipEntryCallback
    implements ZipEntryCallback {
        private final Map entryByPath;
        private final int entryCount;
        private final ZipOutputStream out;
        private final Set names = new HashSet();

        public TransformerZipEntryCallback(ZipEntryTransformerEntry[] entries, ZipOutputStream out) {
            this.entryByPath = ZipUtil.byPath(entries);
            this.entryCount = this.entryByPath.size();
            this.out = out;
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            if (this.names.add(zipEntry.getName())) {
                ZipEntryTransformer entry = (ZipEntryTransformer)this.entryByPath.remove(zipEntry.getName());
                if (entry != null) {
                    entry.transform(in, zipEntry, this.out);
                } else {
                    ZipUtil.copyEntry(zipEntry, in, this.out);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Duplicate entry: {}", (Object)zipEntry.getName());
            }
        }

        public boolean found() {
            return this.entryByPath.size() < this.entryCount;
        }
    }

    private static class RepackZipEntryCallback
    implements ZipEntryCallback {
        private ZipOutputStream out;

        private RepackZipEntryCallback(File dstZip, int compressionLevel) {
            try {
                this.out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dstZip)));
                this.out.setLevel(compressionLevel);
            }
            catch (IOException e) {
                ZipUtil.rethrow(e);
            }
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            ZipUtil.copyEntry(zipEntry, in, this.out);
        }

        private void closeStream() {
            IOUtils.closeQuietly((OutputStream)this.out);
        }
    }

    private static class Unwraper
    implements ZipEntryCallback {
        private final File outputDir;
        private final NameMapper mapper;
        private String rootDir;

        public Unwraper(File outputDir, NameMapper mapper) {
            this.outputDir = outputDir;
            this.mapper = mapper;
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            String root = this.getRootName(zipEntry.getName());
            if (this.rootDir == null) {
                this.rootDir = root;
            } else if (!this.rootDir.equals(root)) {
                throw new ZipException("Unwrapping with multiple roots is not supported, roots: " + this.rootDir + ", " + root);
            }
            String name = this.mapper.map(this.getUnrootedName(root, zipEntry.getName()));
            if (name != null) {
                File file = new File(this.outputDir, name);
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)file);
                } else {
                    FileUtils.forceMkdir((File)file.getParentFile());
                    if (log.isDebugEnabled() && file.exists()) {
                        log.debug("Overwriting file '{}'.", (Object)zipEntry.getName());
                    }
                    FileUtil.copy(in, file);
                }
            }
        }

        private String getUnrootedName(String root, String name) {
            return name.substring(root.length());
        }

        private String getRootName(String name) {
            int idx = (name = name.substring(FilenameUtils.getPrefixLength((String)name))).indexOf(ZipUtil.PATH_SEPARATOR);
            if (idx < 0) {
                throw new ZipException("Entry " + name + " from the root of the zip is not supported");
            }
            return name.substring(0, name.indexOf(ZipUtil.PATH_SEPARATOR));
        }
    }

    private static class Unpacker
    implements ZipEntryCallback {
        private final File outputDir;
        private final NameMapper mapper;

        public Unpacker(File outputDir, NameMapper mapper) {
            this.outputDir = outputDir;
            this.mapper = mapper;
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            String name = this.mapper.map(zipEntry.getName());
            if (name != null) {
                File file = new File(this.outputDir, name);
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)file);
                } else {
                    FileUtils.forceMkdir((File)file.getParentFile());
                    if (log.isDebugEnabled() && file.exists()) {
                        log.debug("Overwriting file '{}'.", (Object)zipEntry.getName());
                    }
                    FileUtil.copy(in, file);
                }
            }
        }
    }

    private static class SingleZipEntryCallback
    implements ZipEntryCallback {
        private final String name;
        private final ZipEntryCallback action;
        private boolean found;

        public SingleZipEntryCallback(String name, ZipEntryCallback action) {
            this.name = name;
            this.action = action;
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            if (this.name.equals(zipEntry.getName())) {
                this.found = true;
                this.action.process(in, zipEntry);
            }
        }

        public boolean found() {
            return this.found;
        }
    }

    private static class FileUnpacker
    implements ZipEntryCallback {
        private final File file;

        public FileUnpacker(File file) {
            this.file = file;
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            FileUtil.copy(in, this.file);
        }
    }

    private static class ByteArrayUnpacker
    implements ZipEntryCallback {
        private byte[] bytes;

        private ByteArrayUnpacker() {
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            this.bytes = IOUtils.toByteArray((InputStream)in);
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

