/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LanguageCodeItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LanguageCodeItem> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(LanguageCodeItem.getter(LanguageCodeItem::languageCodeAsString)).setter(LanguageCodeItem.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Float> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("DurationInSeconds").getter(LanguageCodeItem.getter(LanguageCodeItem::durationInSeconds)).setter(LanguageCodeItem.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, DURATION_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String languageCode;
    private final Float durationInSeconds;

    private LanguageCodeItem(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.durationInSeconds = builder.durationInSeconds;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Float durationInSeconds() {
        return this.durationInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LanguageCodeItem)) {
            return false;
        }
        LanguageCodeItem other = (LanguageCodeItem)obj;
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"LanguageCodeItem").add("LanguageCode", (Object)this.languageCodeAsString()).add("DurationInSeconds", (Object)this.durationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "DurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LanguageCodeItem, T> g) {
        return obj -> g.apply((LanguageCodeItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private Float durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(LanguageCodeItem model) {
            this.languageCode(model.languageCode);
            this.durationInSeconds(model.durationInSeconds);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Float getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Float durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Float durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public LanguageCodeItem build() {
            return new LanguageCodeItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LanguageCodeItem> {
        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder durationInSeconds(Float var1);
    }
}

