/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RedactionType {
    PII("PII"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RedactionType> VALUE_MAP;
    private final String value;

    private RedactionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RedactionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RedactionType> knownValues() {
        EnumSet<RedactionType> knownValues = EnumSet.allOf(RedactionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RedactionType.class, RedactionType::toString);
    }
}

