/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsRequest;
import software.amazon.awssdk.services.transcribe.model.ListMedicalTranscriptionJobsResponse;

public class ListMedicalTranscriptionJobsIterable
implements SdkIterable<ListMedicalTranscriptionJobsResponse> {
    private final TranscribeClient client;
    private final ListMedicalTranscriptionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMedicalTranscriptionJobsIterable(TranscribeClient client, ListMedicalTranscriptionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMedicalTranscriptionJobsResponseFetcher();
    }

    public Iterator<ListMedicalTranscriptionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMedicalTranscriptionJobsResponseFetcher
    implements SyncPageFetcher<ListMedicalTranscriptionJobsResponse> {
        private ListMedicalTranscriptionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMedicalTranscriptionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMedicalTranscriptionJobsResponse nextPage(ListMedicalTranscriptionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMedicalTranscriptionJobsIterable.this.client.listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsIterable.this.firstRequest);
            }
            return ListMedicalTranscriptionJobsIterable.this.client.listMedicalTranscriptionJobs((ListMedicalTranscriptionJobsRequest)((Object)ListMedicalTranscriptionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

