/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.api;

import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.DingTalkJsonParser;
import com.dingtalk.api.DingTalkRequest;
import com.dingtalk.api.DingTalkResponse;
import com.dingtalk.api.DingTalkSignatureUtil;
import com.dingtalk.api.DingTalkUploadRequest;
import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoParser;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.parser.xml.ObjectXmlParser;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDingTalkClient
implements DingTalkClient {
    protected String serverUrl;
    protected String format = "json";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean needCheckRequest = true;
    protected boolean needEnableParser = true;
    protected boolean useSimplifyJson = false;
    protected boolean useGzipEncoding = true;

    public DefaultDingTalkClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public DefaultDingTalkClient(String serverUrl, String format) {
        this(serverUrl);
        this.format = format;
    }

    public DefaultDingTalkClient(String serverUrl, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public <T extends DingTalkResponse> T execute(DingTalkRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends DingTalkResponse> T execute(DingTalkRequest<T> request, String accessToken) throws ApiException {
        return this._execute(request, accessToken);
    }

    private <T extends DingTalkResponse> T _execute(DingTalkRequest<T> request, String accessToken) throws ApiException {
        if (request.getApiCallType() == null || request.getApiCallType().equals("top")) {
            return this._executeTop(request, accessToken);
        }
        return this._executeOApi(request, accessToken);
    }

    @Override
    public <T extends DingTalkResponse> T execute(DingTalkRequest<T> request, String accessKey, String accessSecret) throws ApiException {
        return this.execute(request, accessKey, accessSecret, null, null);
    }

    @Override
    public <T extends DingTalkResponse> T execute(DingTalkRequest<T> request, String accessKey, String accessSecret, String suiteTicket) throws ApiException {
        return this.execute(request, accessKey, accessSecret, suiteTicket, null);
    }

    @Override
    public <T extends DingTalkResponse> T execute(DingTalkRequest<T> request, String accessKey, String accessSecret, String suiteTicket, String corpId) throws ApiException {
        if (request.getApiCallType() == null || request.getApiCallType().equals("top")) {
            return this._executeTop(request, null);
        }
        return this._executeOApi(request, null, accessKey, accessSecret, suiteTicket, corpId);
    }

    private <T extends DingTalkResponse> T _executeTop(DingTalkRequest<T> request, String session) throws ApiException {
        long start = System.currentTimeMillis();
        TaobaoParser<T> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass(), this.useSimplifyJson);
        }
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                DingTalkResponse localResponse = null;
                try {
                    localResponse = (DingTalkResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("v", "2.0");
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)new Date(timestamp));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("session", session);
        protocalOptParams.put("partner_id", this.getSdkVersion());
        if (this.useSimplifyJson) {
            protocalOptParams.put("simplify", Boolean.TRUE.toString());
        }
        requestHolder.setProtocalOptParams(protocalOptParams);
        try {
            String realServerUrl = this.getServerUrl(this.serverUrl, request.getApiMethodName(), session, appParams);
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String fullUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (request instanceof DingTalkUploadRequest) {
                DingTalkUploadRequest uRequest = (DingTalkUploadRequest)request;
                Map<String, FileItem> fileParams = TaobaoUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(fullUrl, (Map<String, String>)appParams, fileParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            } else {
                rsp = WebUtils.doPost(fullUrl, (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap(), null);
            }
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            TaobaoLogger.logApiError("_dingtalk_", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        DingTalkResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = (DingTalkResponse)parser.parse(requestHolder.getResponseBody());
            tRsp.setBody(requestHolder.getResponseBody());
        } else {
            try {
                tRsp = (DingTalkResponse)request.getResponseClass().newInstance();
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        tRsp.setParams(appParams);
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logApiError("_dingtalk_", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return (T)tRsp;
    }

    private <T extends DingTalkResponse> T _executeOApi(DingTalkRequest<T> request, String session) throws ApiException {
        return this._executeOApi(request, session, null, null, null, null);
    }

    private <T extends DingTalkResponse> T _executeOApi(DingTalkRequest<T> request, String session, String accessKey, String accessSecret, String suiteTicket, String corpId) throws ApiException {
        long start = System.currentTimeMillis();
        DingTalkJsonParser<T> parser = null;
        if (this.needEnableParser) {
            parser = new DingTalkJsonParser<T>(request.getResponseClass());
        }
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                DingTalkResponse localResponse = null;
                try {
                    localResponse = (DingTalkResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("access_token", session);
        requestHolder.setProtocalMustParams(protocalMustParams);
        try {
            String fullUrl;
            if (accessKey != null) {
                Long timestamp = System.currentTimeMillis();
                String canonicalString = DingTalkSignatureUtil.getCanonicalStringForIsv(timestamp, suiteTicket);
                String signature = DingTalkSignatureUtil.computeSignature(accessSecret, canonicalString);
                HashMap<String, String> ps = new HashMap<String, String>();
                ps.put("accessKey", accessKey);
                ps.put("signature", signature);
                ps.put("timestamp", timestamp + "");
                if (suiteTicket != null) {
                    ps.put("suiteTicket", suiteTicket);
                }
                if (corpId != null) {
                    ps.put("corpId", corpId);
                }
                String queryStr = DingTalkSignatureUtil.paramToQueryString(ps, "utf-8");
                fullUrl = this.serverUrl.indexOf("?") > 0 ? this.serverUrl + "&" + queryStr : this.serverUrl + "?" + queryStr;
            } else {
                fullUrl = this.serverUrl.indexOf("?") > 0 ? this.serverUrl + (session != null && session.length() > 0 ? "&access_token=" + session : "") : this.serverUrl + (session != null && session.length() > 0 ? "?access_token=" + session : "");
            }
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (request.getHttpMethod().equals("POST")) {
                if (request instanceof DingTalkUploadRequest) {
                    DingTalkUploadRequest uRequest = (DingTalkUploadRequest)request;
                    Map<String, FileItem> fileParams = TaobaoUtils.cleanupMap(uRequest.getFileParams());
                    rsp = WebUtils.doPost(fullUrl, (Map<String, String>)appParams, fileParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
                } else {
                    HashMap<String, Object> jsonParams = new HashMap<String, Object>();
                    for (Map.Entry paramEntry : appParams.entrySet()) {
                        Object childMap;
                        String key = (String)paramEntry.getKey();
                        String value = (String)paramEntry.getValue();
                        if (value.startsWith("[") && value.endsWith("]")) {
                            childMap = (List)TaobaoUtils.jsonToObject(value);
                            jsonParams.put(key, childMap);
                            continue;
                        }
                        if (value.startsWith("{") && value.endsWith("}")) {
                            childMap = (Map)TaobaoUtils.jsonToObject(value);
                            jsonParams.put(key, childMap);
                            continue;
                        }
                        jsonParams.put(key, value);
                    }
                    rsp = WebUtils.doPostWithJson(fullUrl, jsonParams, "UTF-8", this.connectTimeout, this.readTimeout);
                }
            } else {
                rsp = WebUtils.doGet(fullUrl, appParams);
            }
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            TaobaoLogger.logApiError("_dingtalk_", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        DingTalkResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = (DingTalkResponse)parser.parse(requestHolder.getResponseBody());
            tRsp.setBody(requestHolder.getResponseBody());
        } else {
            try {
                tRsp = (DingTalkResponse)request.getResponseClass().newInstance();
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        tRsp.setParams(appParams);
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logApiError("_dingtalk_", request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return (T)tRsp;
    }

    public String getServerUrl(String serverUrl, String apiName, String session, TaobaoHashMap appParams) {
        return serverUrl;
    }

    protected String getSdkVersion() {
        return "top-sdk-java-20180725";
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setUseSimplifyJson(boolean useSimplifyJson) {
        this.useSimplifyJson = useSimplifyJson;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        TaobaoLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

