/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.asn1;

import java.io.IOException;
import org.csii.bouncycastle.asn1.ASN1Boolean;
import org.csii.bouncycastle.asn1.ASN1OctetString;
import org.csii.bouncycastle.asn1.ASN1OutputStream;
import org.csii.bouncycastle.asn1.ASN1Primitive;
import org.csii.bouncycastle.asn1.ASN1TaggedObject;
import org.csii.bouncycastle.util.Arrays;

public class DERBoolean
extends ASN1Primitive {
    private static final byte[] TRUE_VALUE = new byte[]{-1};
    private static final byte[] FALSE_VALUE = new byte[1];
    private byte[] value;
    public static final ASN1Boolean FALSE = new ASN1Boolean(false);
    public static final ASN1Boolean TRUE = new ASN1Boolean(true);

    public static ASN1Boolean getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Boolean) {
            return (ASN1Boolean)obj;
        }
        if (obj instanceof DERBoolean) {
            return ((DERBoolean)obj).isTrue() ? TRUE : FALSE;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Boolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(int value) {
        return value != 0 ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERBoolean) {
            return DERBoolean.getInstance(o);
        }
        return ASN1Boolean.fromOctetString(((ASN1OctetString)o).getOctets());
    }

    DERBoolean(byte[] value) {
        if (value.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        this.value = value[0] == 0 ? FALSE_VALUE : (value[0] == 255 ? TRUE_VALUE : Arrays.clone(value));
    }

    public DERBoolean(boolean value) {
        this.value = value ? TRUE_VALUE : FALSE_VALUE;
    }

    public boolean isTrue() {
        return this.value[0] != 0;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 3;
    }

    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(1, this.value);
    }

    protected boolean asn1Equals(ASN1Primitive o) {
        if (o == null || !(o instanceof DERBoolean)) {
            return false;
        }
        return this.value[0] == ((DERBoolean)o).value[0];
    }

    public int hashCode() {
        return this.value[0];
    }

    public String toString() {
        return this.value[0] != 0 ? "TRUE" : "FALSE";
    }

    static ASN1Boolean fromOctetString(byte[] value) {
        if (value.length != 1) {
            throw new IllegalArgumentException("BOOLEAN value should have 1 byte in it");
        }
        if (value[0] == 0) {
            return FALSE;
        }
        if (value[0] == 255) {
            return TRUE;
        }
        return new ASN1Boolean(value);
    }
}

