/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import org.csii.bouncycastle.asn1.ASN1Encodable;
import org.csii.bouncycastle.asn1.ASN1EncodableVector;
import org.csii.bouncycastle.asn1.ASN1OutputStream;
import org.csii.bouncycastle.asn1.ASN1Set;
import org.csii.bouncycastle.asn1.StreamUtil;

public class DLSet
extends ASN1Set {
    private int bodyLength = -1;

    public DLSet() {
    }

    public DLSet(ASN1Encodable obj) {
        super(obj);
    }

    public DLSet(ASN1EncodableVector v) {
        super(v, false);
    }

    public DLSet(ASN1Encodable[] a) {
        super(a, false);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int length = 0;
            Enumeration e = this.getObjects();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                length += ((ASN1Encodable)obj).toASN1Primitive().toDLObject().encodedLength();
            }
            this.bodyLength = length;
        }
        return this.bodyLength;
    }

    int encodedLength() throws IOException {
        int length = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    void encode(ASN1OutputStream out) throws IOException {
        ASN1OutputStream dOut = out.getDLSubStream();
        int length = this.getBodyLength();
        out.write(49);
        out.writeLength(length);
        Enumeration e = this.getObjects();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            dOut.writeObject((ASN1Encodable)obj);
        }
    }
}

