/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.asn1.cmp;

import java.util.Enumeration;
import org.csii.bouncycastle.asn1.ASN1Encodable;
import org.csii.bouncycastle.asn1.ASN1EncodableVector;
import org.csii.bouncycastle.asn1.ASN1Object;
import org.csii.bouncycastle.asn1.ASN1Primitive;
import org.csii.bouncycastle.asn1.ASN1Sequence;
import org.csii.bouncycastle.asn1.ASN1TaggedObject;
import org.csii.bouncycastle.asn1.DERSequence;
import org.csii.bouncycastle.asn1.DERTaggedObject;
import org.csii.bouncycastle.asn1.cmp.CMPCertificate;
import org.csii.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.csii.bouncycastle.asn1.cmp.PKIStatusInfo;

public class KeyRecRepContent
extends ASN1Object {
    private PKIStatusInfo status;
    private CMPCertificate newSigCert;
    private ASN1Sequence caCerts;
    private ASN1Sequence keyPairHist;

    private KeyRecRepContent(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.status = PKIStatusInfo.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = ASN1TaggedObject.getInstance(en.nextElement());
            switch (tObj.getTagNo()) {
                case 0: {
                    this.newSigCert = CMPCertificate.getInstance(tObj.getObject());
                    break;
                }
                case 1: {
                    this.caCerts = ASN1Sequence.getInstance(tObj.getObject());
                    break;
                }
                case 2: {
                    this.keyPairHist = ASN1Sequence.getInstance(tObj.getObject());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag number: " + tObj.getTagNo());
                }
            }
        }
    }

    public static KeyRecRepContent getInstance(Object o) {
        if (o instanceof KeyRecRepContent) {
            return (KeyRecRepContent)o;
        }
        if (o != null) {
            return new KeyRecRepContent(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CMPCertificate getNewSigCert() {
        return this.newSigCert;
    }

    public CMPCertificate[] getCaCerts() {
        if (this.caCerts == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.caCerts.size()];
        int i = 0;
        while (i != results.length) {
            results[i] = CMPCertificate.getInstance(this.caCerts.getObjectAt(i));
            ++i;
        }
        return results;
    }

    public CertifiedKeyPair[] getKeyPairHist() {
        if (this.keyPairHist == null) {
            return null;
        }
        CertifiedKeyPair[] results = new CertifiedKeyPair[this.keyPairHist.size()];
        int i = 0;
        while (i != results.length) {
            results[i] = CertifiedKeyPair.getInstance(this.keyPairHist.getObjectAt(i));
            ++i;
        }
        return results;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.status);
        this.addOptional(v, 0, this.newSigCert);
        this.addOptional(v, 1, this.caCerts);
        this.addOptional(v, 2, this.keyPairHist);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

