/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.asn1.pkcs;

import org.csii.bouncycastle.asn1.ASN1EncodableVector;
import org.csii.bouncycastle.asn1.ASN1Object;
import org.csii.bouncycastle.asn1.ASN1Primitive;
import org.csii.bouncycastle.asn1.ASN1Sequence;
import org.csii.bouncycastle.asn1.BERSequence;
import org.csii.bouncycastle.asn1.DLSequence;
import org.csii.bouncycastle.asn1.pkcs.ContentInfo;

public class AuthenticatedSafe
extends ASN1Object {
    private ContentInfo[] info;
    private boolean isBer = true;

    private AuthenticatedSafe(ASN1Sequence seq) {
        this.info = new ContentInfo[seq.size()];
        int i = 0;
        while (i != this.info.length) {
            this.info[i] = ContentInfo.getInstance(seq.getObjectAt(i));
            ++i;
        }
        this.isBer = seq instanceof BERSequence;
    }

    public static AuthenticatedSafe getInstance(Object o) {
        if (o instanceof AuthenticatedSafe) {
            return (AuthenticatedSafe)o;
        }
        if (o != null) {
            return new AuthenticatedSafe(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public AuthenticatedSafe(ContentInfo[] info) {
        this.info = info;
    }

    public ContentInfo[] getContentInfo() {
        return this.info;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i != this.info.length) {
            v.add(this.info[i]);
            ++i;
        }
        if (this.isBer) {
            return new BERSequence(v);
        }
        return new DLSequence(v);
    }
}

