/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.asn1.ua;

import java.math.BigInteger;
import org.csii.bouncycastle.asn1.ASN1EncodableVector;
import org.csii.bouncycastle.asn1.ASN1Integer;
import org.csii.bouncycastle.asn1.ASN1Object;
import org.csii.bouncycastle.asn1.ASN1OctetString;
import org.csii.bouncycastle.asn1.ASN1Primitive;
import org.csii.bouncycastle.asn1.ASN1Sequence;
import org.csii.bouncycastle.asn1.ASN1TaggedObject;
import org.csii.bouncycastle.asn1.DEROctetString;
import org.csii.bouncycastle.asn1.DERSequence;
import org.csii.bouncycastle.asn1.DERTaggedObject;
import org.csii.bouncycastle.asn1.ua.DSTU4145BinaryField;
import org.csii.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import org.csii.bouncycastle.asn1.x9.X9IntegerConverter;
import org.csii.bouncycastle.crypto.params.ECDomainParameters;
import org.csii.bouncycastle.math.ec.ECCurve;
import org.csii.bouncycastle.util.Arrays;

public class DSTU4145ECBinary
extends ASN1Object {
    BigInteger version = BigInteger.valueOf(0L);
    DSTU4145BinaryField f;
    ASN1Integer a;
    ASN1OctetString b;
    ASN1Integer n;
    ASN1OctetString bp;

    public DSTU4145ECBinary(ECDomainParameters params) {
        if (!(params.getCurve() instanceof ECCurve.F2m)) {
            throw new IllegalArgumentException("only binary domain is possible");
        }
        ECCurve.F2m curve = (ECCurve.F2m)params.getCurve();
        this.f = new DSTU4145BinaryField(curve.getM(), curve.getK1(), curve.getK2(), curve.getK3());
        this.a = new ASN1Integer(curve.getA().toBigInteger());
        X9IntegerConverter converter = new X9IntegerConverter();
        this.b = new DEROctetString(converter.integerToBytes(curve.getB().toBigInteger(), converter.getByteLength(curve)));
        this.n = new ASN1Integer(params.getN());
        this.bp = new DEROctetString(DSTU4145PointEncoder.encodePoint(params.getG()));
    }

    private DSTU4145ECBinary(ASN1Sequence seq) {
        int index = 0;
        if (seq.getObjectAt(index) instanceof ASN1TaggedObject) {
            ASN1TaggedObject taggedVersion = (ASN1TaggedObject)seq.getObjectAt(index);
            if (taggedVersion.isExplicit() && taggedVersion.getTagNo() == 0) {
                this.version = ASN1Integer.getInstance(taggedVersion.getLoadedObject()).getValue();
                ++index;
            } else {
                throw new IllegalArgumentException("object parse error");
            }
        }
        this.f = DSTU4145BinaryField.getInstance(seq.getObjectAt(index));
        this.a = ASN1Integer.getInstance(seq.getObjectAt(++index));
        this.b = ASN1OctetString.getInstance(seq.getObjectAt(++index));
        this.n = ASN1Integer.getInstance(seq.getObjectAt(++index));
        this.bp = ASN1OctetString.getInstance(seq.getObjectAt(++index));
    }

    public static DSTU4145ECBinary getInstance(Object obj) {
        if (obj instanceof DSTU4145ECBinary) {
            return (DSTU4145ECBinary)obj;
        }
        if (obj != null) {
            return new DSTU4145ECBinary(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DSTU4145BinaryField getField() {
        return this.f;
    }

    public BigInteger getA() {
        return this.a.getValue();
    }

    public byte[] getB() {
        return Arrays.clone(this.b.getOctets());
    }

    public BigInteger getN() {
        return this.n.getValue();
    }

    public byte[] getG() {
        return Arrays.clone(this.bp.getOctets());
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.version.compareTo(BigInteger.valueOf(0L)) != 0) {
            v.add(new DERTaggedObject(true, 0, new ASN1Integer(this.version)));
        }
        v.add(this.f);
        v.add(this.a);
        v.add(this.b);
        v.add(this.n);
        v.add(this.bp);
        return new DERSequence(v);
    }
}

