/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.asn1.x509;

import org.csii.bouncycastle.asn1.ASN1Integer;
import org.csii.bouncycastle.asn1.ASN1Object;
import org.csii.bouncycastle.asn1.ASN1Primitive;
import org.csii.bouncycastle.asn1.ASN1Sequence;
import org.csii.bouncycastle.asn1.ASN1TaggedObject;
import org.csii.bouncycastle.asn1.DERBitString;
import org.csii.bouncycastle.asn1.x500.X500Name;
import org.csii.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.csii.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.csii.bouncycastle.asn1.x509.TBSCertificate;
import org.csii.bouncycastle.asn1.x509.Time;

public class Certificate
extends ASN1Object {
    ASN1Sequence seq;
    TBSCertificate tbsCert;
    AlgorithmIdentifier sigAlgId;
    DERBitString sig;

    public static Certificate getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Certificate.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Certificate getInstance(Object obj) {
        if (obj instanceof Certificate) {
            return (Certificate)obj;
        }
        if (obj != null) {
            return new Certificate(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private Certificate(ASN1Sequence seq) {
        this.seq = seq;
        if (seq.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for a certificate");
        }
        this.tbsCert = TBSCertificate.getInstance(seq.getObjectAt(0));
        this.sigAlgId = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.sig = DERBitString.getInstance(seq.getObjectAt(2));
    }

    public TBSCertificate getTBSCertificate() {
        return this.tbsCert;
    }

    public ASN1Integer getVersion() {
        return this.tbsCert.getVersion();
    }

    public int getVersionNumber() {
        return this.tbsCert.getVersionNumber();
    }

    public ASN1Integer getSerialNumber() {
        return this.tbsCert.getSerialNumber();
    }

    public X500Name getIssuer() {
        return this.tbsCert.getIssuer();
    }

    public Time getStartDate() {
        return this.tbsCert.getStartDate();
    }

    public Time getEndDate() {
        return this.tbsCert.getEndDate();
    }

    public X500Name getSubject() {
        return this.tbsCert.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.tbsCert.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public DERBitString getSignature() {
        return this.sig;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

