/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import org.csii.bouncycastle.crypto.BasicAgreement;
import org.csii.bouncycastle.crypto.CipherParameters;
import org.csii.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.csii.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.csii.bouncycastle.math.ec.ECPoint;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECPoint P = pub.getQ().multiply(this.key.getD()).normalize();
        if (P.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return P.getAffineXCoord().toBigInteger();
    }
}

