/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import org.csii.bouncycastle.crypto.BasicAgreement;
import org.csii.bouncycastle.crypto.CipherParameters;
import org.csii.bouncycastle.crypto.params.ECDomainParameters;
import org.csii.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.csii.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.csii.bouncycastle.math.ec.ECPoint;

public class ECDHCBasicAgreement
implements BasicAgreement {
    ECPrivateKeyParameters key;

    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECDomainParameters params = pub.getParameters();
        BigInteger hd = params.getH().multiply(this.key.getD()).mod(params.getN());
        ECPoint P = pub.getQ().multiply(hd).normalize();
        if (P.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
        }
        return P.getAffineXCoord().toBigInteger();
    }
}

