/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.digests;

import org.csii.bouncycastle.crypto.ExtendedDigest;
import org.csii.bouncycastle.util.Arrays;

public class SHA3Digest
implements ExtendedDigest {
    private static long[] KeccakRoundConstants = SHA3Digest.keccakInitializeRoundConstants();
    private static int[] KeccakRhoOffsets = SHA3Digest.keccakInitializeRhoOffsets();
    private byte[] state = new byte[200];
    private byte[] dataQueue = new byte[192];
    private int rate;
    private int bitsInQueue;
    private int fixedOutputLength;
    private boolean squeezing;
    private int bitsAvailableForSqueezing;
    private byte[] chunk;
    private byte[] oneByte;
    long[] C = new long[5];
    long[] tempA = new long[25];
    long[] chiC = new long[5];

    private static long[] keccakInitializeRoundConstants() {
        long[] keccakRoundConstants = new long[24];
        byte[] LFSRstate = new byte[]{1};
        int i = 0;
        while (i < 24) {
            keccakRoundConstants[i] = 0L;
            int j = 0;
            while (j < 7) {
                int bitPosition = (1 << j) - 1;
                if (SHA3Digest.LFSR86540(LFSRstate)) {
                    int n = i;
                    keccakRoundConstants[n] = keccakRoundConstants[n] ^ 1L << bitPosition;
                }
                ++j;
            }
            ++i;
        }
        return keccakRoundConstants;
    }

    private static boolean LFSR86540(byte[] LFSR) {
        boolean result = (LFSR[0] & 1) != 0;
        LFSR[0] = (LFSR[0] & 0x80) != 0 ? (byte)(LFSR[0] << 1 ^ 0x71) : (byte)(LFSR[0] << 1);
        return result;
    }

    private static int[] keccakInitializeRhoOffsets() {
        int[] keccakRhoOffsets = new int[25];
        keccakRhoOffsets[0] = 0;
        int x = 1;
        int y = 0;
        int t = 0;
        while (t < 24) {
            keccakRhoOffsets[x % 5 + 5 * (y % 5)] = (t + 1) * (t + 2) / 2 % 64;
            int newX = (0 * x + 1 * y) % 5;
            int newY = (2 * x + 3 * y) % 5;
            x = newX;
            y = newY;
            ++t;
        }
        return keccakRhoOffsets;
    }

    private void clearDataQueueSection(int off, int len) {
        int i = off;
        while (i != off + len) {
            this.dataQueue[i] = 0;
            ++i;
        }
    }

    public SHA3Digest() {
        this.init(0);
    }

    public SHA3Digest(int bitLength) {
        this.init(bitLength);
    }

    public SHA3Digest(SHA3Digest source) {
        System.arraycopy(source.state, 0, this.state, 0, source.state.length);
        System.arraycopy(source.dataQueue, 0, this.dataQueue, 0, source.dataQueue.length);
        this.rate = source.rate;
        this.bitsInQueue = source.bitsInQueue;
        this.fixedOutputLength = source.fixedOutputLength;
        this.squeezing = source.squeezing;
        this.bitsAvailableForSqueezing = source.bitsAvailableForSqueezing;
        this.chunk = Arrays.clone(source.chunk);
        this.oneByte = Arrays.clone(source.oneByte);
    }

    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    public int getDigestSize() {
        return this.fixedOutputLength / 8;
    }

    public void update(byte in) {
        this.oneByte[0] = in;
        this.doUpdate(this.oneByte, 0, 8L);
    }

    public void update(byte[] in, int inOff, int len) {
        this.doUpdate(in, inOff, (long)len * 8L);
    }

    public int doFinal(byte[] out, int outOff) {
        this.squeeze(out, outOff, this.fixedOutputLength);
        this.reset();
        return this.getDigestSize();
    }

    public void reset() {
        this.init(this.fixedOutputLength);
    }

    public int getByteLength() {
        return this.rate / 8;
    }

    private void init(int bitLength) {
        switch (bitLength) {
            case 0: 
            case 288: {
                this.initSponge(1024, 576);
                break;
            }
            case 224: {
                this.initSponge(1152, 448);
                break;
            }
            case 256: {
                this.initSponge(1088, 512);
                break;
            }
            case 384: {
                this.initSponge(832, 768);
                break;
            }
            case 512: {
                this.initSponge(576, 1024);
                break;
            }
            default: {
                throw new IllegalArgumentException("bitLength must be one of 224, 256, 384, or 512.");
            }
        }
    }

    private void doUpdate(byte[] data, int off, long databitlen) {
        if (databitlen % 8L == 0L) {
            this.absorb(data, off, databitlen);
        } else {
            this.absorb(data, off, databitlen - databitlen % 8L);
            byte[] lastByte = new byte[]{(byte)(data[off + (int)(databitlen / 8L)] >> (int)(8L - databitlen % 8L))};
            this.absorb(lastByte, off, databitlen % 8L);
        }
    }

    private void initSponge(int rate, int capacity) {
        if (rate + capacity != 1600) {
            throw new IllegalStateException("rate + capacity != 1600");
        }
        if (rate <= 0 || rate >= 1600 || rate % 64 != 0) {
            throw new IllegalStateException("invalid rate value");
        }
        this.rate = rate;
        this.fixedOutputLength = 0;
        Arrays.fill(this.state, (byte)0);
        Arrays.fill(this.dataQueue, (byte)0);
        this.bitsInQueue = 0;
        this.squeezing = false;
        this.bitsAvailableForSqueezing = 0;
        this.fixedOutputLength = capacity / 2;
        this.chunk = new byte[rate / 8];
        this.oneByte = new byte[1];
    }

    private void absorbQueue() {
        this.KeccakAbsorb(this.state, this.dataQueue, this.rate / 8);
        this.bitsInQueue = 0;
    }

    private void absorb(byte[] data, int off, long databitlen) {
        if (this.bitsInQueue % 8 != 0) {
            throw new IllegalStateException("attempt to absorb with odd length queue.");
        }
        if (this.squeezing) {
            throw new IllegalStateException("attempt to absorb while squeezing.");
        }
        long i = 0L;
        while (i < databitlen) {
            if (this.bitsInQueue == 0 && databitlen >= (long)this.rate && i <= databitlen - (long)this.rate) {
                long wholeBlocks = (databitlen - i) / (long)this.rate;
                long j = 0L;
                while (j < wholeBlocks) {
                    System.arraycopy(data, (int)((long)off + i / 8L + j * (long)this.chunk.length), this.chunk, 0, this.chunk.length);
                    this.KeccakAbsorb(this.state, this.chunk, this.chunk.length);
                    ++j;
                }
                i += wholeBlocks * (long)this.rate;
                continue;
            }
            int partialBlock = (int)(databitlen - i);
            if (partialBlock + this.bitsInQueue > this.rate) {
                partialBlock = this.rate - this.bitsInQueue;
            }
            int partialByte = partialBlock % 8;
            System.arraycopy(data, off + (int)(i / 8L), this.dataQueue, this.bitsInQueue / 8, (partialBlock -= partialByte) / 8);
            this.bitsInQueue += partialBlock;
            i += (long)partialBlock;
            if (this.bitsInQueue == this.rate) {
                this.absorbQueue();
            }
            if (partialByte <= 0) continue;
            int mask = (1 << partialByte) - 1;
            this.dataQueue[this.bitsInQueue / 8] = (byte)(data[off + (int)(i / 8L)] & mask);
            this.bitsInQueue += partialByte;
            i += (long)partialByte;
        }
    }

    private void padAndSwitchToSqueezingPhase() {
        if (this.bitsInQueue + 1 == this.rate) {
            int n = this.bitsInQueue / 8;
            this.dataQueue[n] = (byte)(this.dataQueue[n] | 1 << this.bitsInQueue % 8);
            this.absorbQueue();
            this.clearDataQueueSection(0, this.rate / 8);
        } else {
            this.clearDataQueueSection((this.bitsInQueue + 7) / 8, this.rate / 8 - (this.bitsInQueue + 7) / 8);
            int n = this.bitsInQueue / 8;
            this.dataQueue[n] = (byte)(this.dataQueue[n] | 1 << this.bitsInQueue % 8);
        }
        int n = (this.rate - 1) / 8;
        this.dataQueue[n] = (byte)(this.dataQueue[n] | 1 << (this.rate - 1) % 8);
        this.absorbQueue();
        if (this.rate == 1024) {
            this.KeccakExtract1024bits(this.state, this.dataQueue);
            this.bitsAvailableForSqueezing = 1024;
        } else {
            this.KeccakExtract(this.state, this.dataQueue, this.rate / 64);
            this.bitsAvailableForSqueezing = this.rate;
        }
        this.squeezing = true;
    }

    private void squeeze(byte[] output, int offset, long outputLength) {
        if (!this.squeezing) {
            this.padAndSwitchToSqueezingPhase();
        }
        if (outputLength % 8L != 0L) {
            throw new IllegalStateException("outputLength not a multiple of 8");
        }
        long i = 0L;
        while (i < outputLength) {
            int partialBlock;
            if (this.bitsAvailableForSqueezing == 0) {
                this.keccakPermutation(this.state);
                if (this.rate == 1024) {
                    this.KeccakExtract1024bits(this.state, this.dataQueue);
                    this.bitsAvailableForSqueezing = 1024;
                } else {
                    this.KeccakExtract(this.state, this.dataQueue, this.rate / 64);
                    this.bitsAvailableForSqueezing = this.rate;
                }
            }
            if ((long)(partialBlock = this.bitsAvailableForSqueezing) > outputLength - i) {
                partialBlock = (int)(outputLength - i);
            }
            System.arraycopy(this.dataQueue, (this.rate - this.bitsAvailableForSqueezing) / 8, output, offset + (int)(i / 8L), partialBlock / 8);
            this.bitsAvailableForSqueezing -= partialBlock;
            i += (long)partialBlock;
        }
    }

    private void fromBytesToWords(long[] stateAsWords, byte[] state) {
        int i = 0;
        while (i < 25) {
            stateAsWords[i] = 0L;
            int index = i * 8;
            int j = 0;
            while (j < 8) {
                int n = i;
                stateAsWords[n] = stateAsWords[n] | ((long)state[index + j] & 0xFFL) << 8 * j;
                ++j;
            }
            ++i;
        }
    }

    private void fromWordsToBytes(byte[] state, long[] stateAsWords) {
        int i = 0;
        while (i < 25) {
            int index = i * 8;
            int j = 0;
            while (j < 8) {
                state[index + j] = (byte)(stateAsWords[i] >>> 8 * j & 0xFFL);
                ++j;
            }
            ++i;
        }
    }

    private void keccakPermutation(byte[] state) {
        long[] longState = new long[state.length / 8];
        this.fromBytesToWords(longState, state);
        this.keccakPermutationOnWords(longState);
        this.fromWordsToBytes(state, longState);
    }

    private void keccakPermutationAfterXor(byte[] state, byte[] data, int dataLengthInBytes) {
        int i = 0;
        while (i < dataLengthInBytes) {
            int n = i;
            state[n] = (byte)(state[n] ^ data[i]);
            ++i;
        }
        this.keccakPermutation(state);
    }

    private void keccakPermutationOnWords(long[] state) {
        int i = 0;
        while (i < 24) {
            this.theta(state);
            this.rho(state);
            this.pi(state);
            this.chi(state);
            this.iota(state, i);
            ++i;
        }
    }

    private void theta(long[] A) {
        int x = 0;
        while (x < 5) {
            this.C[x] = 0L;
            int y = 0;
            while (y < 5) {
                int n = x;
                this.C[n] = this.C[n] ^ A[x + 5 * y];
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 5) {
            long dX = this.C[(x + 1) % 5] << 1 ^ this.C[(x + 1) % 5] >>> 63 ^ this.C[(x + 4) % 5];
            int y = 0;
            while (y < 5) {
                int n = x + 5 * y;
                A[n] = A[n] ^ dX;
                ++y;
            }
            ++x;
        }
    }

    private void rho(long[] A) {
        int x = 0;
        while (x < 5) {
            int y = 0;
            while (y < 5) {
                int index = x + 5 * y;
                A[index] = KeccakRhoOffsets[index] != 0 ? A[index] << KeccakRhoOffsets[index] ^ A[index] >>> 64 - KeccakRhoOffsets[index] : A[index];
                ++y;
            }
            ++x;
        }
    }

    private void pi(long[] A) {
        System.arraycopy(A, 0, this.tempA, 0, this.tempA.length);
        int x = 0;
        while (x < 5) {
            int y = 0;
            while (y < 5) {
                A[y + 5 * ((2 * x + 3 * y) % 5)] = this.tempA[x + 5 * y];
                ++y;
            }
            ++x;
        }
    }

    private void chi(long[] A) {
        int y = 0;
        while (y < 5) {
            int x = 0;
            while (x < 5) {
                this.chiC[x] = A[x + 5 * y] ^ (A[(x + 1) % 5 + 5 * y] ^ 0xFFFFFFFFFFFFFFFFL) & A[(x + 2) % 5 + 5 * y];
                ++x;
            }
            x = 0;
            while (x < 5) {
                A[x + 5 * y] = this.chiC[x];
                ++x;
            }
            ++y;
        }
    }

    private void iota(long[] A, int indexRound) {
        A[0] = A[0] ^ KeccakRoundConstants[indexRound];
    }

    private void KeccakAbsorb(byte[] byteState, byte[] data, int dataInBytes) {
        this.keccakPermutationAfterXor(byteState, data, dataInBytes);
    }

    private void KeccakExtract1024bits(byte[] byteState, byte[] data) {
        System.arraycopy(byteState, 0, data, 0, 128);
    }

    private void KeccakExtract(byte[] byteState, byte[] data, int laneCount) {
        System.arraycopy(byteState, 0, data, 0, laneCount * 8);
    }
}

