/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.ec;

import java.math.BigInteger;
import org.csii.bouncycastle.crypto.CipherParameters;
import org.csii.bouncycastle.crypto.ec.ECPair;
import org.csii.bouncycastle.crypto.ec.ECPairFactorTransform;
import org.csii.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.csii.bouncycastle.math.ec.ECPoint;

public class ECFixedTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private BigInteger k;

    public ECFixedTransform(BigInteger k) {
        this.k = k;
    }

    public void init(CipherParameters param) {
        if (!(param instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("ECPublicKeyParameters are required for fixed transform.");
        }
        this.key = (ECPublicKeyParameters)param;
    }

    public ECPair transform(ECPair cipherText) {
        if (this.key == null) {
            throw new IllegalStateException("ECFixedTransform not initialised");
        }
        ECPoint g = this.key.getParameters().getG();
        ECPoint gamma = g.multiply(this.k);
        ECPoint phi = this.key.getQ().multiply(this.k).add(cipherText.getY());
        return new ECPair(cipherText.getX().add(gamma).normalize(), phi.normalize());
    }

    public BigInteger getTransformValue() {
        return this.k;
    }
}

