/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.csii.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.csii.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.csii.bouncycastle.crypto.KeyGenerationParameters;
import org.csii.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import org.csii.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.csii.bouncycastle.crypto.params.DHParameters;
import org.csii.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.csii.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

