/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.csii.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.csii.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.csii.bouncycastle.crypto.KeyGenerationParameters;
import org.csii.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.csii.bouncycastle.crypto.params.DSAParameters;
import org.csii.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.csii.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.csii.bouncycastle.util.BigIntegers;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        return BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random);
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

