/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.generators;

import org.csii.bouncycastle.crypto.PBEParametersGenerator;
import org.csii.bouncycastle.crypto.digests.SHA256Digest;
import org.csii.bouncycastle.crypto.engines.Salsa20Engine;
import org.csii.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.csii.bouncycastle.crypto.params.KeyParameter;
import org.csii.bouncycastle.crypto.util.Pack;
import org.csii.bouncycastle.util.Arrays;

public class SCrypt {
    public static byte[] generate(byte[] P, byte[] S, int N, int r, int p, int dkLen) {
        return SCrypt.MFcrypt(P, S, N, r, p, dkLen);
    }

    private static byte[] MFcrypt(byte[] P, byte[] S, int N, int r, int p, int dkLen) {
        byte[] byArray;
        int MFLenBytes = r * 128;
        byte[] bytes = SCrypt.SingleIterationPBKDF2(P, S, p * MFLenBytes);
        int[] B = null;
        try {
            int BLen = bytes.length >>> 2;
            B = new int[BLen];
            Pack.littleEndianToInt(bytes, 0, B);
            int MFLenWords = MFLenBytes >>> 2;
            int BOff = 0;
            while (BOff < BLen) {
                SCrypt.SMix(B, BOff, N, r);
                BOff += MFLenWords;
            }
            Pack.intToLittleEndian(B, bytes, 0);
            byArray = SCrypt.SingleIterationPBKDF2(P, bytes, dkLen);
        }
        catch (Throwable throwable) {
            SCrypt.Clear(bytes);
            SCrypt.Clear(B);
            throw throwable;
        }
        SCrypt.Clear(bytes);
        SCrypt.Clear(B);
        return byArray;
    }

    private static byte[] SingleIterationPBKDF2(byte[] P, byte[] S, int dkLen) {
        PKCS5S2ParametersGenerator pGen = new PKCS5S2ParametersGenerator(new SHA256Digest());
        pGen.init(P, S, 1);
        KeyParameter key = (KeyParameter)((PBEParametersGenerator)pGen).generateDerivedMacParameters(dkLen * 8);
        return key.getKey();
    }

    private static void SMix(int[] B, int BOff, int N, int r) {
        int BCount = r * 32;
        int[] blockX1 = new int[16];
        int[] blockX2 = new int[16];
        int[] blockY = new int[BCount];
        int[] X = new int[BCount];
        int[][] V = new int[N][];
        try {
            System.arraycopy(B, BOff, X, 0, BCount);
            int i = 0;
            while (i < N) {
                V[i] = Arrays.clone(X);
                SCrypt.BlockMix(X, blockX1, blockX2, blockY, r);
                ++i;
            }
            int mask = N - 1;
            int i2 = 0;
            while (i2 < N) {
                int j = X[BCount - 16] & mask;
                SCrypt.Xor(X, V[j], 0, X);
                SCrypt.BlockMix(X, blockX1, blockX2, blockY, r);
                ++i2;
            }
            System.arraycopy(X, 0, B, BOff, BCount);
        }
        catch (Throwable throwable) {
            SCrypt.ClearAll(V);
            SCrypt.ClearAll(new int[][]{X, blockX1, blockX2, blockY});
            throw throwable;
        }
        SCrypt.ClearAll(V);
        SCrypt.ClearAll(new int[][]{X, blockX1, blockX2, blockY});
    }

    private static void BlockMix(int[] B, int[] X1, int[] X2, int[] Y, int r) {
        System.arraycopy(B, B.length - 16, X1, 0, 16);
        int BOff = 0;
        int YOff = 0;
        int halfLen = B.length >>> 1;
        int i = 2 * r;
        while (i > 0) {
            SCrypt.Xor(X1, B, BOff, X2);
            Salsa20Engine.salsaCore(8, X2, X1);
            System.arraycopy(X1, 0, Y, YOff, 16);
            YOff = halfLen + BOff - YOff;
            BOff += 16;
            --i;
        }
        System.arraycopy(Y, 0, B, 0, Y.length);
    }

    private static void Xor(int[] a, int[] b, int bOff, int[] output) {
        int i = output.length - 1;
        while (i >= 0) {
            output[i] = a[i] ^ b[bOff + i];
            --i;
        }
    }

    private static void Clear(byte[] array) {
        if (array != null) {
            Arrays.fill(array, (byte)0);
        }
    }

    private static void Clear(int[] array) {
        if (array != null) {
            Arrays.fill(array, 0);
        }
    }

    private static void ClearAll(int[][] arrays) {
        int i = 0;
        while (i < arrays.length) {
            SCrypt.Clear(arrays[i]);
            ++i;
        }
    }
}

