/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.macs;

import org.csii.bouncycastle.crypto.CipherParameters;
import org.csii.bouncycastle.crypto.DataLengthException;
import org.csii.bouncycastle.crypto.InvalidCipherTextException;
import org.csii.bouncycastle.crypto.Mac;
import org.csii.bouncycastle.crypto.modes.GCMBlockCipher;
import org.csii.bouncycastle.crypto.params.AEADParameters;
import org.csii.bouncycastle.crypto.params.KeyParameter;
import org.csii.bouncycastle.crypto.params.ParametersWithIV;

public class GMac
implements Mac {
    private final GCMBlockCipher cipher;
    private final int macSizeBits;

    public GMac(GCMBlockCipher cipher) {
        this.cipher = cipher;
        this.macSizeBits = 128;
    }

    public GMac(GCMBlockCipher cipher, int macSizeBits) {
        this.cipher = cipher;
        this.macSizeBits = macSizeBits;
    }

    public void init(CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("GMAC requires ParametersWithIV");
        }
        ParametersWithIV param = (ParametersWithIV)params;
        byte[] iv = param.getIV();
        KeyParameter keyParam = (KeyParameter)param.getParameters();
        this.cipher.init(true, new AEADParameters(keyParam, this.macSizeBits, iv));
    }

    public String getAlgorithmName() {
        return String.valueOf(this.cipher.getUnderlyingCipher().getAlgorithmName()) + "-GMAC";
    }

    public int getMacSize() {
        return this.macSizeBits / 8;
    }

    public void update(byte in) throws IllegalStateException {
        this.cipher.processAADByte(in);
    }

    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        this.cipher.processAADBytes(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        try {
            return this.cipher.doFinal(out, outOff);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public void reset() {
        this.cipher.reset();
    }
}

