/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.modes;

import org.csii.bouncycastle.crypto.BlockCipher;
import org.csii.bouncycastle.crypto.CipherParameters;
import org.csii.bouncycastle.crypto.DataLengthException;
import org.csii.bouncycastle.crypto.modes.CFBBlockCipher;
import org.csii.bouncycastle.crypto.params.KeyParameter;
import org.csii.bouncycastle.crypto.params.ParametersWithIV;
import org.csii.bouncycastle.crypto.params.ParametersWithRandom;
import org.csii.bouncycastle.crypto.params.ParametersWithSBox;

public class GCFBBlockCipher
implements BlockCipher {
    private static final byte[] C;
    private final CFBBlockCipher cfbEngine;
    private KeyParameter key;
    private long counter = 0L;
    private boolean forEncryption;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 105;
        byArray[2] = 114;
        byArray[3] = 34;
        byArray[4] = 100;
        byArray[5] = -55;
        byArray[6] = 4;
        byArray[7] = 35;
        byArray[8] = -115;
        byArray[9] = 58;
        byArray[10] = -37;
        byArray[11] = -106;
        byArray[12] = 70;
        byArray[13] = -23;
        byArray[14] = 42;
        byArray[15] = -60;
        byArray[16] = 24;
        byArray[17] = -2;
        byArray[18] = -84;
        byArray[19] = -108;
        byArray[21] = -19;
        byArray[22] = 7;
        byArray[23] = 18;
        byArray[24] = -64;
        byArray[25] = -122;
        byArray[26] = -36;
        byArray[27] = -62;
        byArray[28] = -17;
        byArray[29] = 76;
        byArray[30] = -87;
        byArray[31] = 43;
        C = byArray;
    }

    public GCFBBlockCipher(BlockCipher engine) {
        this.cfbEngine = new CFBBlockCipher(engine, engine.getBlockSize() * 8);
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.counter = 0L;
        this.cfbEngine.init(forEncryption, params);
        this.forEncryption = forEncryption;
        if (params instanceof ParametersWithIV) {
            params = ((ParametersWithIV)params).getParameters();
        }
        if (params instanceof ParametersWithRandom) {
            params = ((ParametersWithRandom)params).getParameters();
        }
        if (params instanceof ParametersWithSBox) {
            params = ((ParametersWithSBox)params).getParameters();
        }
        this.key = (KeyParameter)params;
    }

    public String getAlgorithmName() {
        return "G" + this.cfbEngine.getAlgorithmName();
    }

    public int getBlockSize() {
        return this.cfbEngine.getBlockSize();
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.counter > 0L && this.counter % 1024L == 0L) {
            BlockCipher base = this.cfbEngine.getUnderlyingCipher();
            base.init(false, this.key);
            byte[] nextKey = new byte[32];
            base.processBlock(C, 0, nextKey, 0);
            base.processBlock(C, 8, nextKey, 8);
            base.processBlock(C, 16, nextKey, 16);
            base.processBlock(C, 24, nextKey, 24);
            this.key = new KeyParameter(nextKey);
            byte[] iv = new byte[8];
            base.init(true, this.key);
            base.processBlock(this.cfbEngine.getCurrentIV(), 0, iv, 0);
            this.cfbEngine.init(this.forEncryption, new ParametersWithIV(this.key, iv));
        }
        this.counter += (long)this.cfbEngine.getBlockSize();
        return this.cfbEngine.processBlock(in, inOff, out, outOff);
    }

    public void reset() {
        this.counter = 0L;
        this.cfbEngine.reset();
    }
}

