/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.modes.gcm;

import org.csii.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.csii.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.csii.bouncycastle.util.Arrays;

public class BasicGCMExponentiator
implements GCMExponentiator {
    private int[] x;

    public void init(byte[] x) {
        this.x = GCMUtil.asInts(x);
    }

    public void exponentiateX(long pow, byte[] output) {
        int[] y = GCMUtil.oneAsInts();
        if (pow > 0L) {
            int[] powX = Arrays.clone(this.x);
            do {
                if ((pow & 1L) != 0L) {
                    GCMUtil.multiply(y, powX);
                }
                GCMUtil.multiply(powX, powX);
            } while ((pow >>>= 1) > 0L);
        }
        GCMUtil.asBytes(y, output);
    }
}

