/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.csii.bouncycastle.crypto.CipherParameters;
import org.csii.bouncycastle.crypto.DSA;
import org.csii.bouncycastle.crypto.params.DSAKeyParameters;
import org.csii.bouncycastle.crypto.params.DSAParameters;
import org.csii.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.csii.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.csii.bouncycastle.crypto.params.ParametersWithRandom;
import org.csii.bouncycastle.crypto.signers.DSAKCalculator;
import org.csii.bouncycastle.crypto.signers.RandomDSAKCalculator;

public class DSASigner
implements DSA {
    private final DSAKCalculator kCalculator;
    private DSAKeyParameters key;
    private SecureRandom random;

    public DSASigner() {
        this.kCalculator = new RandomDSAKCalculator();
    }

    public DSASigner(DSAKCalculator kCalculator) {
        this.kCalculator = kCalculator;
    }

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (DSAPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (DSAPrivateKeyParameters)param;
            }
        } else {
            this.key = (DSAPublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] message) {
        DSAParameters params = this.key.getParameters();
        BigInteger m = this.calculateE(params.getQ(), message);
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(params.getQ(), ((DSAPrivateKeyParameters)this.key).getX(), message);
        } else {
            this.kCalculator.init(params.getQ(), this.random);
        }
        BigInteger k = this.kCalculator.nextK();
        BigInteger r = params.getG().modPow(k, params.getP()).mod(params.getQ());
        k = k.modInverse(params.getQ()).multiply(m.add(((DSAPrivateKeyParameters)this.key).getX().multiply(r)));
        BigInteger s = k.mod(params.getQ());
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        DSAParameters params = this.key.getParameters();
        BigInteger m = this.calculateE(params.getQ(), message);
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r) >= 0 || params.getQ().compareTo(r) <= 0) {
            return false;
        }
        if (zero.compareTo(s) >= 0 || params.getQ().compareTo(s) <= 0) {
            return false;
        }
        BigInteger w = s.modInverse(params.getQ());
        BigInteger u1 = m.multiply(w).mod(params.getQ());
        BigInteger u2 = r.multiply(w).mod(params.getQ());
        u1 = params.getG().modPow(u1, params.getP());
        u2 = ((DSAPublicKeyParameters)this.key).getY().modPow(u2, params.getP());
        BigInteger v = u1.multiply(u2).mod(params.getP()).mod(params.getQ());
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        if (n.bitLength() >= message.length * 8) {
            return new BigInteger(1, message);
        }
        byte[] trunc = new byte[n.bitLength() / 8];
        System.arraycopy(message, 0, trunc, 0, trunc.length);
        return new BigInteger(1, trunc);
    }
}

