/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.tls;

import java.io.IOException;
import org.csii.bouncycastle.crypto.BlockCipher;
import org.csii.bouncycastle.crypto.Digest;
import org.csii.bouncycastle.crypto.Mac;
import org.csii.bouncycastle.crypto.StreamCipher;
import org.csii.bouncycastle.crypto.digests.MD5Digest;
import org.csii.bouncycastle.crypto.digests.SHA1Digest;
import org.csii.bouncycastle.crypto.digests.SHA256Digest;
import org.csii.bouncycastle.crypto.digests.SHA384Digest;
import org.csii.bouncycastle.crypto.digests.SHA512Digest;
import org.csii.bouncycastle.crypto.engines.AESFastEngine;
import org.csii.bouncycastle.crypto.engines.CamelliaEngine;
import org.csii.bouncycastle.crypto.engines.DESedeEngine;
import org.csii.bouncycastle.crypto.engines.RC4Engine;
import org.csii.bouncycastle.crypto.engines.SEEDEngine;
import org.csii.bouncycastle.crypto.engines.Salsa20Engine;
import org.csii.bouncycastle.crypto.macs.HMac;
import org.csii.bouncycastle.crypto.modes.AEADBlockCipher;
import org.csii.bouncycastle.crypto.modes.CBCBlockCipher;
import org.csii.bouncycastle.crypto.modes.CCMBlockCipher;
import org.csii.bouncycastle.crypto.modes.GCMBlockCipher;
import org.csii.bouncycastle.crypto.tls.AbstractTlsCipherFactory;
import org.csii.bouncycastle.crypto.tls.TlsAEADCipher;
import org.csii.bouncycastle.crypto.tls.TlsBlockCipher;
import org.csii.bouncycastle.crypto.tls.TlsCipher;
import org.csii.bouncycastle.crypto.tls.TlsContext;
import org.csii.bouncycastle.crypto.tls.TlsFatalAlert;
import org.csii.bouncycastle.crypto.tls.TlsNullCipher;
import org.csii.bouncycastle.crypto.tls.TlsStreamCipher;

public class DefaultTlsCipherFactory
extends AbstractTlsCipherFactory {
    public TlsCipher createCipher(TlsContext context, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(context, macAlgorithm);
            }
            case 8: {
                return this.createAESCipher(context, 16, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(context, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(context, 16, 8);
            }
            case 17: {
                return this.createCipher_AES_CCM(context, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(context, 32, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(context, 16, 16);
            }
            case 9: {
                return this.createAESCipher(context, 32, macAlgorithm);
            }
            case 11: {
                return this.createCipher_AES_GCM(context, 32, 16);
            }
            case 12: {
                return this.createCamelliaCipher(context, 16, macAlgorithm);
            }
            case 13: {
                return this.createCamelliaCipher(context, 32, macAlgorithm);
            }
            case 100: {
                return this.createSalsa20Cipher(context, 12, 32, macAlgorithm);
            }
            case 0: {
                return this.createNullCipher(context, macAlgorithm);
            }
            case 2: {
                return this.createRC4Cipher(context, 16, macAlgorithm);
            }
            case 101: {
                return this.createSalsa20Cipher(context, 20, 32, macAlgorithm);
            }
            case 14: {
                return this.createSEEDCipher(context, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsBlockCipher createAESCipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_AES_CCM(), this.createAEADBlockCipher_AES_CCM(), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_AES_GCM(), this.createAEADBlockCipher_AES_GCM(), cipherKeySize, macSize);
    }

    protected TlsBlockCipher createCamelliaCipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createCamelliaBlockCipher(), this.createCamelliaBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsBlockCipher createDESedeCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), 24);
    }

    protected TlsNullCipher createNullCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsNullCipher(context, this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm));
    }

    protected TlsStreamCipher createRC4Cipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsStreamCipher(context, this.createRC4StreamCipher(), this.createRC4StreamCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsStreamCipher createSalsa20Cipher(TlsContext context, int rounds, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsStreamCipher(context, this.createSalsa20StreamCipher(rounds), this.createSalsa20StreamCipher(rounds), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsBlockCipher createSEEDCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createSEEDBlockCipher(), this.createSEEDBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), 16);
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return new CCMBlockCipher(new AESFastEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(new CamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected StreamCipher createSalsa20StreamCipher(int rounds) {
        return new Salsa20Engine(rounds);
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher(new SEEDEngine());
    }

    protected Digest createHMACDigest(int macAlgorithm) throws IOException {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
            case 5: {
                return new SHA512Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected Mac createMac(int macAlgorithm) throws IOException {
        return new HMac(this.createHMACDigest(macAlgorithm));
    }
}

