/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.tls;

import java.io.IOException;
import org.csii.bouncycastle.crypto.InvalidCipherTextException;
import org.csii.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.csii.bouncycastle.crypto.engines.RSABlindedEngine;
import org.csii.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.csii.bouncycastle.crypto.params.ParametersWithRandom;
import org.csii.bouncycastle.crypto.params.RSAKeyParameters;
import org.csii.bouncycastle.crypto.tls.AbstractTlsEncryptionCredentials;
import org.csii.bouncycastle.crypto.tls.Certificate;
import org.csii.bouncycastle.crypto.tls.TlsContext;
import org.csii.bouncycastle.crypto.tls.TlsFatalAlert;

public class DefaultTlsEncryptionCredentials
extends AbstractTlsEncryptionCredentials {
    protected TlsContext context;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public DefaultTlsEncryptionCredentials(TlsContext context, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(privateKey instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.context = context;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] decryptPreMasterSecret(byte[] encryptedPreMasterSecret) throws IOException {
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(false, new ParametersWithRandom(this.privateKey, this.context.getSecureRandom()));
        try {
            return encoding.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(47);
        }
    }
}

