/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.csii.bouncycastle.crypto.InvalidCipherTextException;
import org.csii.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.csii.bouncycastle.crypto.engines.RSABlindedEngine;
import org.csii.bouncycastle.crypto.params.ParametersWithRandom;
import org.csii.bouncycastle.crypto.params.RSAKeyParameters;
import org.csii.bouncycastle.crypto.tls.ProtocolVersion;
import org.csii.bouncycastle.crypto.tls.TlsContext;
import org.csii.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.csii.bouncycastle.crypto.tls.TlsFatalAlert;
import org.csii.bouncycastle.crypto.tls.TlsUtils;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsContext context, RSAKeyParameters rsaServerPublicKey, OutputStream output) throws IOException {
        byte[] premasterSecret = new byte[48];
        context.getSecureRandom().nextBytes(premasterSecret);
        TlsUtils.writeVersion(context.getClientVersion(), premasterSecret, 0);
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(true, new ParametersWithRandom(rsaServerPublicKey, context.getSecureRandom()));
        try {
            byte[] encryptedPreMasterSecret = encoding.processBlock(premasterSecret, 0, premasterSecret.length);
            if (TlsUtils.isSSL(context)) {
                output.write(encryptedPreMasterSecret);
            } else {
                TlsUtils.writeOpaque16(encryptedPreMasterSecret, output);
            }
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(80);
        }
        return premasterSecret;
    }

    public static byte[] safeDecryptPreMasterSecret(TlsContext context, TlsEncryptionCredentials encryptionCredentials, byte[] encryptedPreMasterSecret) {
        ProtocolVersion clientVersion = context.getClientVersion();
        boolean versionNumberCheckDisabled = false;
        byte[] R = new byte[48];
        context.getSecureRandom().nextBytes(R);
        byte[] M = TlsUtils.EMPTY_BYTES;
        try {
            M = encryptionCredentials.decryptPreMasterSecret(encryptedPreMasterSecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (M.length != 48) {
            TlsUtils.writeVersion(clientVersion, R, 0);
            return R;
        }
        if (!versionNumberCheckDisabled || !clientVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10)) {
            TlsUtils.writeVersion(clientVersion, M, 0);
        }
        return M;
    }
}

