/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.crypto.tls;

import java.io.IOException;
import org.csii.bouncycastle.crypto.Digest;
import org.csii.bouncycastle.crypto.StreamCipher;
import org.csii.bouncycastle.crypto.params.KeyParameter;
import org.csii.bouncycastle.crypto.tls.TlsCipher;
import org.csii.bouncycastle.crypto.tls.TlsContext;
import org.csii.bouncycastle.crypto.tls.TlsFatalAlert;
import org.csii.bouncycastle.crypto.tls.TlsMac;
import org.csii.bouncycastle.crypto.tls.TlsUtils;
import org.csii.bouncycastle.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    private static boolean encryptThenMAC = false;
    protected TlsContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsStreamCipher(TlsContext context, StreamCipher clientWriteCipher, StreamCipher serverWriteCipher, Digest clientWriteDigest, Digest serverWriteDigest, int cipherKeySize) throws IOException {
        KeyParameter decryptParams;
        KeyParameter encryptParams;
        boolean isServer = context.isServer();
        this.context = context;
        this.encryptCipher = clientWriteCipher;
        this.decryptCipher = serverWriteCipher;
        int key_block_size = 2 * cipherKeySize + clientWriteDigest.getDigestSize() + serverWriteDigest.getDigestSize();
        byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
        int offset = 0;
        TlsMac clientWriteMac = new TlsMac(context, clientWriteDigest, key_block, offset, clientWriteDigest.getDigestSize());
        TlsMac serverWriteMac = new TlsMac(context, serverWriteDigest, key_block, offset += clientWriteDigest.getDigestSize(), serverWriteDigest.getDigestSize());
        KeyParameter clientWriteKey = new KeyParameter(key_block, offset += serverWriteDigest.getDigestSize(), cipherKeySize);
        KeyParameter serverWriteKey = new KeyParameter(key_block, offset += cipherKeySize, cipherKeySize);
        if ((offset += cipherKeySize) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (isServer) {
            this.writeMac = serverWriteMac;
            this.readMac = clientWriteMac;
            this.encryptCipher = serverWriteCipher;
            this.decryptCipher = clientWriteCipher;
            encryptParams = serverWriteKey;
            decryptParams = clientWriteKey;
        } else {
            this.writeMac = clientWriteMac;
            this.readMac = serverWriteMac;
            this.encryptCipher = clientWriteCipher;
            this.decryptCipher = serverWriteCipher;
            encryptParams = clientWriteKey;
            decryptParams = serverWriteKey;
        }
        this.encryptCipher.init(true, encryptParams);
        this.decryptCipher.init(false, decryptParams);
    }

    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeMac.getSize();
    }

    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) {
        byte[] outBuf = new byte[len + this.writeMac.getSize()];
        this.encryptCipher.processBytes(plaintext, offset, len, outBuf, 0);
        if (encryptThenMAC) {
            byte[] mac = this.writeMac.calculateMac(seqNo, type, outBuf, 0, len);
            System.arraycopy(mac, 0, outBuf, len, mac.length);
        } else {
            byte[] mac = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
            this.encryptCipher.processBytes(mac, 0, mac.length, outBuf, len);
        }
        return outBuf;
    }

    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int macSize = this.readMac.getSize();
        if (len < macSize) {
            throw new TlsFatalAlert(50);
        }
        int plaintextLength = len - macSize;
        if (encryptThenMAC) {
            int ciphertextEnd = offset + len;
            this.checkMAC(seqNo, type, ciphertext, ciphertextEnd - macSize, ciphertextEnd, ciphertext, offset, plaintextLength);
            byte[] deciphered = new byte[plaintextLength];
            this.decryptCipher.processBytes(ciphertext, offset, plaintextLength, deciphered, 0);
            return deciphered;
        }
        byte[] deciphered = new byte[len];
        this.decryptCipher.processBytes(ciphertext, offset, len, deciphered, 0);
        this.checkMAC(seqNo, type, deciphered, plaintextLength, len, deciphered, 0, plaintextLength);
        return Arrays.copyOfRange(deciphered, 0, plaintextLength);
    }

    private void checkMAC(long seqNo, short type, byte[] recBuf, int recStart, int recEnd, byte[] calcBuf, int calcOff, int calcLen) throws IOException {
        byte[] computedMac;
        byte[] receivedMac = Arrays.copyOfRange(recBuf, recStart, recEnd);
        if (!Arrays.constantTimeAreEqual(receivedMac, computedMac = this.readMac.calculateMac(seqNo, type, calcBuf, calcOff, calcLen))) {
            throw new TlsFatalAlert(20);
        }
    }
}

