/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.jcajce.provider.asymmetric.ecgost;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import org.csii.bouncycastle.asn1.ASN1Encodable;
import org.csii.bouncycastle.asn1.ASN1Object;
import org.csii.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.csii.bouncycastle.asn1.ASN1OctetString;
import org.csii.bouncycastle.asn1.ASN1Primitive;
import org.csii.bouncycastle.asn1.ASN1Sequence;
import org.csii.bouncycastle.asn1.DERBitString;
import org.csii.bouncycastle.asn1.DERNull;
import org.csii.bouncycastle.asn1.DERObjectIdentifier;
import org.csii.bouncycastle.asn1.DEROctetString;
import org.csii.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.csii.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.csii.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.csii.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.csii.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.csii.bouncycastle.asn1.x9.X962Parameters;
import org.csii.bouncycastle.asn1.x9.X9ECParameters;
import org.csii.bouncycastle.asn1.x9.X9ECPoint;
import org.csii.bouncycastle.asn1.x9.X9IntegerConverter;
import org.csii.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.csii.bouncycastle.crypto.params.ECDomainParameters;
import org.csii.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.csii.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.csii.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import org.csii.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.csii.bouncycastle.jce.interfaces.ECPointEncoder;
import org.csii.bouncycastle.jce.interfaces.ECPublicKey;
import org.csii.bouncycastle.jce.provider.BouncyCastleProvider;
import org.csii.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.csii.bouncycastle.jce.spec.ECParameterSpec;
import org.csii.bouncycastle.jce.spec.ECPublicKeySpec;
import org.csii.bouncycastle.math.ec.ECCurve;
import org.csii.bouncycastle.math.ec.ECPoint;

public class BCECGOST3410PublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "ECGOST3410";
    private boolean withCompression;
    private transient ECPoint q;
    private transient ECParameterSpec ecSpec;
    private transient GOST3410PublicKeyAlgParameters gostParams;

    public BCECGOST3410PublicKey(String algorithm, BCECGOST3410PublicKey key) {
        this.algorithm = algorithm;
        this.q = key.q;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.gostParams = key.gostParams;
    }

    public BCECGOST3410PublicKey(ECPublicKeySpec spec) {
        this.q = spec.getQ();
        if (spec.getParams() != null) {
            this.ecSpec = spec.getParams();
        } else {
            if (this.q.getCurve() == null) {
                ECParameterSpec s = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
                this.q = s.getCurve().createPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger(), false);
            }
            this.ecSpec = null;
        }
    }

    public BCECGOST3410PublicKey(String algorithm, ECPublicKeyParameters params, ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        this.ecSpec = spec == null ? new ECParameterSpec(dp.getCurve(), dp.getG(), dp.getN(), dp.getH(), dp.getSeed()) : spec;
    }

    public BCECGOST3410PublicKey(String algorithm, ECPublicKeyParameters params) {
        this.algorithm = algorithm;
        this.q = params.getQ();
        this.ecSpec = null;
    }

    BCECGOST3410PublicKey(ECPublicKey key) {
        this.q = key.getQ();
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParameters();
    }

    BCECGOST3410PublicKey(String algorithm, ECPoint q, ECParameterSpec ecSpec) {
        this.algorithm = algorithm;
        this.q = q;
        this.ecSpec = ecSpec;
    }

    BCECGOST3410PublicKey(SubjectPublicKeyInfo info) {
        this.populateFromPubKeyInfo(info);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo info) {
        if (info.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            ASN1OctetString key;
            DERBitString bits = info.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                key = (ASN1OctetString)ASN1Primitive.fromByteArray(bits.getBytes());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("error recovering public key");
            }
            byte[] keyEnc = key.getOctets();
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            int i = 0;
            while (i != x.length) {
                x[i] = keyEnc[31 - i];
                ++i;
            }
            i = 0;
            while (i != y.length) {
                y[i] = keyEnc[63 - i];
                ++i;
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)info.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec spec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            this.ecSpec = spec;
            this.q = spec.getCurve().createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
        } else {
            int qLength;
            ECCurve curve;
            X962Parameters params = X962Parameters.getInstance(info.getAlgorithmId().getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(params.getParameters());
                X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
                this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName(oid), ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
                curve = this.ecSpec.getCurve();
            } else if (params.isImplicitlyCA()) {
                this.ecSpec = null;
                curve = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getCurve();
            } else {
                X9ECParameters ecP = X9ECParameters.getInstance(params.getParameters());
                this.ecSpec = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
                curve = this.ecSpec.getCurve();
            }
            DERBitString bits = info.getPublicKeyData();
            byte[] data = bits.getBytes();
            ASN1OctetString key = new DEROctetString(data);
            if (data[0] == 4 && data[1] == data.length - 2 && (data[2] == 2 || data[2] == 3) && (qLength = new X9IntegerConverter().getByteLength(curve)) >= data.length - 3) {
                try {
                    key = (ASN1OctetString)ASN1Primitive.fromByteArray(data);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint derQ = new X9ECPoint(curve, key);
            this.q = derQ.getPoint();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        SubjectPublicKeyInfo info;
        if (this.algorithm.equals("ECGOST3410")) {
            ASN1Object params = null;
            if (this.gostParams != null) {
                params = this.gostParams;
            } else if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                params = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            } else {
                ECParameterSpec p = this.ecSpec;
                ECCurve curve = p.getG().getCurve();
                ECPoint generator = curve.createPoint(p.getG().getX().toBigInteger(), p.getG().getY().toBigInteger(), this.withCompression);
                X9ECParameters ecP = new X9ECParameters(p.getCurve(), generator, p.getN(), p.getH(), p.getSeed());
                params = new X962Parameters(ecP);
            }
            ECPoint qq = this.getQ();
            ECPoint point = qq.getCurve().createPoint(qq.getX().toBigInteger(), qq.getY().toBigInteger(), false);
            ASN1OctetString p = ASN1OctetString.getInstance(new X9ECPoint(point));
            BigInteger bX = this.q.getX().toBigInteger();
            BigInteger bY = this.q.getY().toBigInteger();
            byte[] encKey = new byte[64];
            byte[] val = bX.toByteArray();
            int i = 0;
            while (i != 32) {
                encKey[i] = val[val.length - 1 - i];
                ++i;
            }
            val = bY.toByteArray();
            i = 0;
            while (i != 32) {
                encKey[32 + i] = val[val.length - 1 - i];
                ++i;
            }
            try {
                info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, (ASN1Encodable)params), new DEROctetString(encKey));
            }
            catch (IOException e) {
                return null;
            }
        } else {
            X962Parameters params = null;
            if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                DERObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                if (curveOid == null) {
                    curveOid = new DERObjectIdentifier(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                }
                params = new X962Parameters(curveOid);
            } else if (this.ecSpec == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else {
                ECParameterSpec p = this.ecSpec;
                ECCurve curve = p.getG().getCurve();
                ECPoint generator = curve.createPoint(p.getG().getX().toBigInteger(), p.getG().getY().toBigInteger(), this.withCompression);
                X9ECParameters ecP = new X9ECParameters(p.getCurve(), generator, p.getN(), p.getH(), p.getSeed());
                params = new X962Parameters(ecP);
            }
            ECCurve curve = this.engineGetQ().getCurve();
            ECPoint point = curve.createPoint(this.getQ().getX().toBigInteger(), this.getQ().getY().toBigInteger(), this.withCompression);
            ASN1OctetString p = ASN1OctetString.getInstance(new X9ECPoint(point));
            info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params), p.getOctets());
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(info);
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    public ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    public ECPoint engineGetQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("EC Public Key").append(nl);
        buf.append("            X: ").append(this.getQ().getX().toBigInteger().toString(16)).append(nl);
        buf.append("            Y: ").append(this.getQ().getY().toBigInteger().toString(16)).append(nl);
        return buf.toString();
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BCECGOST3410PublicKey)) {
            return false;
        }
        BCECGOST3410PublicKey other = (BCECGOST3410PublicKey)o;
        return this.getQ().equals(other.getQ()) && this.engineGetSpec().equals(other.engineGetSpec());
    }

    public int hashCode() {
        return this.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(enc)));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

