/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.jcajce.provider.symmetric;

import org.csii.bouncycastle.crypto.BlockCipher;
import org.csii.bouncycastle.crypto.CipherKeyGenerator;
import org.csii.bouncycastle.crypto.engines.CAST6Engine;
import org.csii.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.csii.bouncycastle.crypto.macs.GMac;
import org.csii.bouncycastle.crypto.modes.GCMBlockCipher;
import org.csii.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;

public final class CAST6 {
    static /* synthetic */ Class class$0;

    private CAST6() {
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new CAST6Engine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new CAST6Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("CAST6", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.csii.bouncycastle.jcajce.provider.symmetric.CAST6");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PREFIX = clazz.getName();
        }

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.CAST6", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.CAST6", String.valueOf(PREFIX) + "$KeyGen");
            this.addGMacAlgorithm(provider, "CAST6", String.valueOf(PREFIX) + "$GMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addPoly1305Algorithm(provider, "CAST6", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.csii.bouncycastle.crypto.macs.Poly1305(new CAST6Engine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-CAST6", 256, new Poly1305KeyGenerator());
        }
    }
}

