/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.jcajce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.csii.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.csii.bouncycastle.crypto.BlockCipher;
import org.csii.bouncycastle.crypto.CipherKeyGenerator;
import org.csii.bouncycastle.crypto.engines.CamelliaEngine;
import org.csii.bouncycastle.crypto.engines.CamelliaWrapEngine;
import org.csii.bouncycastle.crypto.engines.RFC3211WrapEngine;
import org.csii.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.csii.bouncycastle.crypto.macs.GMac;
import org.csii.bouncycastle.crypto.modes.CBCBlockCipher;
import org.csii.bouncycastle.crypto.modes.GCMBlockCipher;
import org.csii.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class Camellia {
    static /* synthetic */ Class class$0;

    private Camellia() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for Camellia parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("Camellia", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Camellia IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new CamelliaEngine()), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new CamelliaEngine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new CamelliaEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int keySize) {
            super("Camellia", keySize, new CipherKeyGenerator());
        }
    }

    public static class KeyGen128
    extends KeyGen {
        public KeyGen128() {
            super(128);
        }
    }

    public static class KeyGen192
    extends KeyGen {
        public KeyGen192() {
            super(192);
        }
    }

    public static class KeyGen256
    extends KeyGen {
        public KeyGen256() {
            super(256);
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.csii.bouncycastle.jcajce.provider.symmetric.Camellia");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PREFIX = clazz.getName();
        }

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.CAMELLIA", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters." + NTTObjectIdentifiers.id_camellia128_cbc, "CAMELLIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters." + NTTObjectIdentifiers.id_camellia192_cbc, "CAMELLIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters." + NTTObjectIdentifiers.id_camellia256_cbc, "CAMELLIA");
            provider.addAlgorithm("AlgorithmParameterGenerator.CAMELLIA", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NTTObjectIdentifiers.id_camellia128_cbc, "CAMELLIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NTTObjectIdentifiers.id_camellia192_cbc, "CAMELLIA");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + NTTObjectIdentifiers.id_camellia256_cbc, "CAMELLIA");
            provider.addAlgorithm("Cipher.CAMELLIA", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher." + NTTObjectIdentifiers.id_camellia128_cbc, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher." + NTTObjectIdentifiers.id_camellia192_cbc, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher." + NTTObjectIdentifiers.id_camellia256_cbc, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher.CAMELLIARFC3211WRAP", String.valueOf(PREFIX) + "$RFC3211Wrap");
            provider.addAlgorithm("Cipher.CAMELLIAWRAP", String.valueOf(PREFIX) + "$Wrap");
            provider.addAlgorithm("Alg.Alias.Cipher." + NTTObjectIdentifiers.id_camellia128_wrap, "CAMELLIAWRAP");
            provider.addAlgorithm("Alg.Alias.Cipher." + NTTObjectIdentifiers.id_camellia192_wrap, "CAMELLIAWRAP");
            provider.addAlgorithm("Alg.Alias.Cipher." + NTTObjectIdentifiers.id_camellia256_wrap, "CAMELLIAWRAP");
            provider.addAlgorithm("KeyGenerator.CAMELLIA", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("KeyGenerator." + NTTObjectIdentifiers.id_camellia128_wrap, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator." + NTTObjectIdentifiers.id_camellia192_wrap, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator." + NTTObjectIdentifiers.id_camellia256_wrap, String.valueOf(PREFIX) + "$KeyGen256");
            provider.addAlgorithm("KeyGenerator." + NTTObjectIdentifiers.id_camellia128_cbc, String.valueOf(PREFIX) + "$KeyGen128");
            provider.addAlgorithm("KeyGenerator." + NTTObjectIdentifiers.id_camellia192_cbc, String.valueOf(PREFIX) + "$KeyGen192");
            provider.addAlgorithm("KeyGenerator." + NTTObjectIdentifiers.id_camellia256_cbc, String.valueOf(PREFIX) + "$KeyGen256");
            this.addGMacAlgorithm(provider, "CAMELLIA", String.valueOf(PREFIX) + "$GMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addPoly1305Algorithm(provider, "CAMELLIA", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.csii.bouncycastle.crypto.macs.Poly1305(new CamelliaEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Camellia", 256, new Poly1305KeyGenerator());
        }
    }

    public static class RFC3211Wrap
    extends BaseWrapCipher {
        public RFC3211Wrap() {
            super(new RFC3211WrapEngine(new CamelliaEngine()), 16);
        }
    }

    public static class Wrap
    extends BaseWrapCipher {
        public Wrap() {
            super(new CamelliaWrapEngine());
        }
    }
}

