/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.jcajce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.csii.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.csii.bouncycastle.crypto.BufferedBlockCipher;
import org.csii.bouncycastle.crypto.CipherKeyGenerator;
import org.csii.bouncycastle.crypto.engines.GOST28147Engine;
import org.csii.bouncycastle.crypto.macs.GOST28147Mac;
import org.csii.bouncycastle.crypto.modes.CBCBlockCipher;
import org.csii.bouncycastle.crypto.modes.GCFBBlockCipher;
import org.csii.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.csii.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class GOST28147 {
    static /* synthetic */ Class class$0;

    private GOST28147() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("GOST28147", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "GOST IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new GOST28147Engine()), 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new GOST28147Engine());
        }
    }

    public static class GCFB
    extends BaseBlockCipher {
        public GCFB() {
            super(new BufferedBlockCipher(new GCFBBlockCipher(new GOST28147Engine())), 64);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int keySize) {
            super("GOST28147", keySize, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new GOST28147Mac());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.csii.bouncycastle.jcajce.provider.symmetric.GOST28147");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PREFIX = clazz.getName();
        }

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.GOST28147", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Alg.Alias.Cipher.GOST", "GOST28147");
            provider.addAlgorithm("Alg.Alias.Cipher.GOST-28147", "GOST28147");
            provider.addAlgorithm("Cipher." + CryptoProObjectIdentifiers.gostR28147_gcfb, String.valueOf(PREFIX) + "$GCFB");
            provider.addAlgorithm("KeyGenerator.GOST28147", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("Alg.Alias.KeyGenerator.GOST", "GOST28147");
            provider.addAlgorithm("Alg.Alias.KeyGenerator.GOST-28147", "GOST28147");
            provider.addAlgorithm("Alg.Alias.KeyGenerator." + CryptoProObjectIdentifiers.gostR28147_gcfb, "GOST28147");
            provider.addAlgorithm("Mac.GOST28147MAC", String.valueOf(PREFIX) + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
        }
    }
}

