/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.jcajce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.csii.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.csii.bouncycastle.crypto.BlockCipher;
import org.csii.bouncycastle.crypto.CipherKeyGenerator;
import org.csii.bouncycastle.crypto.engines.SEEDEngine;
import org.csii.bouncycastle.crypto.engines.SEEDWrapEngine;
import org.csii.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.csii.bouncycastle.crypto.macs.GMac;
import org.csii.bouncycastle.crypto.modes.CBCBlockCipher;
import org.csii.bouncycastle.crypto.modes.GCMBlockCipher;
import org.csii.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.csii.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class SEED {
    static /* synthetic */ Class class$0;

    private SEED() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for SEED parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("SEED", "BC");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "SEED IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SEEDEngine()), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new SEEDEngine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new SEEDEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SEED", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.csii.bouncycastle.jcajce.provider.symmetric.SEED");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PREFIX = clazz.getName();
        }

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.SEED", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            provider.addAlgorithm("AlgorithmParameterGenerator.SEED", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + KISAObjectIdentifiers.id_seedCBC, "SEED");
            provider.addAlgorithm("Cipher.SEED", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher." + KISAObjectIdentifiers.id_seedCBC, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher.SEEDWRAP", String.valueOf(PREFIX) + "$Wrap");
            provider.addAlgorithm("Alg.Alias.Cipher." + KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, "SEEDWRAP");
            provider.addAlgorithm("KeyGenerator.SEED", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("KeyGenerator." + KISAObjectIdentifiers.id_seedCBC, String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("KeyGenerator." + KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, String.valueOf(PREFIX) + "$KeyGen");
            this.addGMacAlgorithm(provider, "SEED", String.valueOf(PREFIX) + "$GMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addPoly1305Algorithm(provider, "SEED", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.csii.bouncycastle.crypto.macs.Poly1305(new SEEDEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-SEED", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Wrap
    extends BaseWrapCipher {
        public Wrap() {
            super(new SEEDWrapEngine());
        }
    }
}

