/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.jce.provider;

import org.csii.bouncycastle.crypto.CipherParameters;
import org.csii.bouncycastle.crypto.Digest;
import org.csii.bouncycastle.crypto.PBEParametersGenerator;
import org.csii.bouncycastle.crypto.digests.MD5Digest;
import org.csii.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.csii.bouncycastle.crypto.digests.SHA1Digest;
import org.csii.bouncycastle.crypto.params.KeyParameter;
import org.csii.bouncycastle.crypto.params.ParametersWithIV;

class OldPKCS12ParametersGenerator
extends PBEParametersGenerator {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    private Digest digest;
    private int u;
    private int v;

    public OldPKCS12ParametersGenerator(Digest digest) {
        this.digest = digest;
        if (digest instanceof MD5Digest) {
            this.u = 16;
            this.v = 64;
        } else if (digest instanceof SHA1Digest) {
            this.u = 20;
            this.v = 64;
        } else if (digest instanceof RIPEMD160Digest) {
            this.u = 20;
            this.v = 64;
        } else {
            throw new IllegalArgumentException("Digest " + digest.getAlgorithmName() + " unsupported");
        }
    }

    private void adjust(byte[] a, int aOff, byte[] b) {
        int x = (b[b.length - 1] & 0xFF) + (a[aOff + b.length - 1] & 0xFF) + 1;
        a[aOff + b.length - 1] = (byte)x;
        x >>>= 8;
        int i = b.length - 2;
        while (i >= 0) {
            a[aOff + i] = (byte)(x += (b[i] & 0xFF) + (a[aOff + i] & 0xFF));
            x >>>= 8;
            --i;
        }
    }

    private byte[] generateDerivedKey(int idByte, int n) {
        byte[] P;
        byte[] S;
        byte[] D = new byte[this.v];
        byte[] dKey = new byte[n];
        int i = 0;
        while (i != D.length) {
            D[i] = (byte)idByte;
            ++i;
        }
        if (this.salt != null && this.salt.length != 0) {
            S = new byte[this.v * ((this.salt.length + this.v - 1) / this.v)];
            int i2 = 0;
            while (i2 != S.length) {
                S[i2] = this.salt[i2 % this.salt.length];
                ++i2;
            }
        } else {
            S = new byte[]{};
        }
        if (this.password != null && this.password.length != 0) {
            P = new byte[this.v * ((this.password.length + this.v - 1) / this.v)];
            int i3 = 0;
            while (i3 != P.length) {
                P[i3] = this.password[i3 % this.password.length];
                ++i3;
            }
        } else {
            P = new byte[]{};
        }
        byte[] I = new byte[S.length + P.length];
        System.arraycopy(S, 0, I, 0, S.length);
        System.arraycopy(P, 0, I, S.length, P.length);
        byte[] B = new byte[this.v];
        int c = (n + this.u - 1) / this.u;
        int i4 = 1;
        while (i4 <= c) {
            byte[] A = new byte[this.u];
            this.digest.update(D, 0, D.length);
            this.digest.update(I, 0, I.length);
            this.digest.doFinal(A, 0);
            int j = 1;
            while (j != this.iterationCount) {
                this.digest.update(A, 0, A.length);
                this.digest.doFinal(A, 0);
                ++j;
            }
            j = 0;
            while (j != B.length) {
                B[i4] = A[j % A.length];
                ++j;
            }
            j = 0;
            while (j != I.length / this.v) {
                this.adjust(I, j * this.v, B);
                ++j;
            }
            if (i4 == c) {
                System.arraycopy(A, 0, dKey, (i4 - 1) * this.u, dKey.length - (i4 - 1) * this.u);
            } else {
                System.arraycopy(A, 0, dKey, (i4 - 1) * this.u, A.length);
            }
            ++i4;
        }
        return dKey;
    }

    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] dKey = this.generateDerivedKey(1, keySize /= 8);
        return new KeyParameter(dKey, 0, keySize);
    }

    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[] dKey = this.generateDerivedKey(1, keySize /= 8);
        byte[] iv = this.generateDerivedKey(2, ivSize /= 8);
        return new ParametersWithIV(new KeyParameter(dKey, 0, keySize), iv, 0, ivSize);
    }

    public CipherParameters generateDerivedMacParameters(int keySize) {
        byte[] dKey = this.generateDerivedKey(3, keySize /= 8);
        return new KeyParameter(dKey, 0, keySize);
    }
}

