/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.csii.bouncycastle.jce.exception.ExtCertPathBuilderException;
import org.csii.bouncycastle.jce.provider.AnnotatedException;
import org.csii.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.csii.bouncycastle.util.Selector;
import org.csii.bouncycastle.x509.ExtendedPKIXBuilderParameters;
import org.csii.bouncycastle.x509.X509CertStoreSelector;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    private Exception certPathException;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection targets;
        if (!(params instanceof PKIXBuilderParameters) && !(params instanceof ExtendedPKIXBuilderParameters)) {
            StringBuffer stringBuffer = new StringBuffer("Parameters must be an instance of ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.security.cert.PKIXBuilderParameters");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append(" or ");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.csii.bouncycastle.x509.ExtendedPKIXBuilderParameters");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new InvalidAlgorithmParameterException(stringBuffer2.append(clazz2.getName()).append(".").toString());
        }
        ExtendedPKIXBuilderParameters pkixParams = null;
        pkixParams = params instanceof ExtendedPKIXBuilderParameters ? (ExtendedPKIXBuilderParameters)params : (ExtendedPKIXBuilderParameters)ExtendedPKIXBuilderParameters.getInstance((PKIXBuilderParameters)params);
        ArrayList certPathList = new ArrayList();
        Selector certSelect = pkixParams.getTargetConstraints();
        if (!(certSelect instanceof X509CertStoreSelector)) {
            StringBuffer stringBuffer = new StringBuffer("TargetConstraints must be an instance of ");
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.csii.bouncycastle.x509.X509CertStoreSelector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new CertPathBuilderException(stringBuffer.append(clazz.getName()).append(" for ").append(this.getClass().getName()).append(" class.").toString());
        }
        try {
            targets = CertPathValidatorUtilities.findCertificates((X509CertStoreSelector)certSelect, pkixParams.getStores());
            targets.addAll(CertPathValidatorUtilities.findCertificates((X509CertStoreSelector)certSelect, pkixParams.getCertStores()));
        }
        catch (AnnotatedException e) {
            throw new ExtCertPathBuilderException("Error finding target certificate.", e);
        }
        if (targets.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult result = null;
        Iterator targetIter = targets.iterator();
        while (targetIter.hasNext() && result == null) {
            X509Certificate cert = (X509Certificate)targetIter.next();
            result = this.build(cert, pkixParams, certPathList);
        }
        if (result == null && this.certPathException != null) {
            if (this.certPathException instanceof AnnotatedException) {
                throw new CertPathBuilderException(this.certPathException.getMessage(), this.certPathException.getCause());
            }
            throw new CertPathBuilderException("Possible certificate chain could not be validated.", this.certPathException);
        }
        if (result == null && this.certPathException == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return result;
    }

    protected CertPathBuilderResult build(X509Certificate tbvCert, ExtendedPKIXBuilderParameters pkixParams, List tbvPath) {
        CertPathValidator validator;
        CertificateFactory cFact;
        if (tbvPath.contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getExcludedCerts().contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getMaxPathLength() != -1 && tbvPath.size() - 1 > pkixParams.getMaxPathLength()) {
            return null;
        }
        tbvPath.add(tbvCert);
        CertPathBuilderResult builderResult = null;
        try {
            cFact = CertificateFactory.getInstance("X.509", "BC");
            validator = CertPathValidator.getInstance("PKIX", "BC");
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            if (CertPathValidatorUtilities.findTrustAnchor(tbvCert, pkixParams.getTrustAnchors(), pkixParams.getSigProvider()) != null) {
                CertPath certPath = null;
                PKIXCertPathValidatorResult result = null;
                try {
                    certPath = cFact.generateCertPath(tbvPath);
                }
                catch (Exception e) {
                    throw new AnnotatedException("Certification path could not be constructed from certificate list.", e);
                }
                try {
                    result = (PKIXCertPathValidatorResult)validator.validate(certPath, pkixParams);
                }
                catch (Exception e) {
                    throw new AnnotatedException("Certification path could not be validated.", e);
                }
                return new PKIXCertPathBuilderResult(certPath, result.getTrustAnchor(), result.getPolicyTree(), result.getPublicKey());
            }
            try {
                CertPathValidatorUtilities.addAdditionalStoresFromAltNames(tbvCert, pkixParams);
            }
            catch (CertificateParsingException e) {
                throw new AnnotatedException("No additiontal X.509 stores can be added from certificate locations.", e);
            }
            HashSet issuers = new HashSet();
            try {
                issuers.addAll(CertPathValidatorUtilities.findIssuerCerts(tbvCert, pkixParams));
            }
            catch (AnnotatedException e) {
                throw new AnnotatedException("Cannot find issuer certificate for certificate in certification path.", e);
            }
            if (issuers.isEmpty()) {
                throw new AnnotatedException("No issuer certificate for certificate in certification path found.");
            }
            Iterator it = issuers.iterator();
            while (it.hasNext() && builderResult == null) {
                X509Certificate issuer = (X509Certificate)it.next();
                builderResult = this.build(issuer, pkixParams, tbvPath);
            }
        }
        catch (AnnotatedException e) {
            this.certPathException = e;
        }
        if (builderResult == null) {
            tbvPath.remove(tbvCert);
        }
        return builderResult;
    }
}

