/*
 * Decompiled with CFR 0.152.
 */
package org.csii.bouncycastle.math.ec;

import java.math.BigInteger;
import org.csii.bouncycastle.math.ec.ECMultiplier;
import org.csii.bouncycastle.math.ec.ECPoint;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    public ECPoint multiply(ECPoint p, BigInteger k) {
        int sign = k.signum();
        if (sign == 0 || p.isInfinity()) {
            return p.getCurve().getInfinity();
        }
        ECPoint positive = this.multiplyPositive(p, k.abs());
        return sign > 0 ? positive : positive.negate();
    }

    protected abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);
}

